/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websocketsevents;

import de.quantummaid.httpmaid.events.EventsChains;
import de.quantummaid.httpmaid.events.ExternalEventMapping;
import de.quantummaid.httpmaid.generator.GenerationCondition;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebSocketForEventFilter;
import de.quantummaid.httpmaid.websockets.WebSocketTag;
import de.quantummaid.httpmaid.websockets.WebsocketChainKeys;
import de.quantummaid.httpmaid.websockets.WebsocketChains;
import de.quantummaid.httpmaid.websocketsevents.WebSocketsExternalEventMapping;

public final class Conditions {
    private Conditions() {
    }

    public static GenerationCondition webSocketIsTaggedWith(String tag) {
        Validators.validateNotNullNorEmpty((String)tag, (String)"tag");
        WebSocketTag webSocketTag = WebSocketTag.webSocketTag((String)tag);
        return metaData -> metaData.getOptional(WebsocketChainKeys.WEBSOCKET_TAG).map(arg_0 -> ((WebSocketTag)webSocketTag).equals(arg_0)).orElse(false);
    }

    public static ExternalEventMapping forwardingItToAllWebSocketsThat(WebSocketForEventFilter filter) {
        Validators.validateNotNull((Object)filter, (String)"filter");
        return WebSocketsExternalEventMapping.webSocketsExternalEventMapping(EventsChains.MAP_EVENT_TO_RESPONSE, filter, (webSockets, metaData) -> {
            metaData.set(WebsocketChainKeys.RECIPIENT_WEBSOCKETS, webSockets);
            metaData.set(WebsocketChainKeys.IS_WEBSOCKET_MESSAGE, (Object)true);
        });
    }

    public static ExternalEventMapping closingAllWebSockets() {
        return Conditions.closingAllWebSocketsThat((metaData, event) -> true);
    }

    public static ExternalEventMapping closingAllWebSocketsThat(WebSocketForEventFilter filter) {
        Validators.validateNotNull((Object)filter, (String)"filter");
        return WebSocketsExternalEventMapping.webSocketsExternalEventMapping(WebsocketChains.WEBSOCKET_CLOSE, filter, (webSockets, metaData) -> metaData.set(WebsocketChainKeys.WEBSOCKETS_TO_CLOSE, webSockets));
    }
}

