/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websocketsevents;

import de.quantummaid.eventmaid.processingContext.EventType;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.events.EventModule;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebsocketChainKeys;
import de.quantummaid.httpmaid.websocketsevents.EventMapping;
import java.util.List;
import java.util.Optional;

public final class DetermineEventForWebSocketsProcessor
implements Processor {
    private final List<EventMapping> eventMappings;

    public static Processor determineEventForWebSockets(List<EventMapping> eventMappings) {
        Validators.validateNotNull(eventMappings, (String)"eventMappings");
        return new DetermineEventForWebSocketsProcessor(eventMappings);
    }

    public void apply(MetaData metaData) {
        if (metaData.getOptional(WebsocketChainKeys.IS_WEBSOCKET_MESSAGE).orElse(false).booleanValue()) {
            EventType eventType = this.eventMappings.stream().map(useCaseMapping -> useCaseMapping.getEventIfMatching(metaData)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new RuntimeException("No event found"));
            metaData.set(EventModule.EVENT_TYPE, (Object)eventType);
        }
    }

    public String toString() {
        return "DetermineEventForWebSocketsProcessor(eventMappings=" + this.eventMappings + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetermineEventForWebSocketsProcessor)) {
            return false;
        }
        DetermineEventForWebSocketsProcessor other = (DetermineEventForWebSocketsProcessor)o;
        List<EventMapping> this$eventMappings = this.eventMappings;
        List<EventMapping> other$eventMappings = other.eventMappings;
        return !(this$eventMappings == null ? other$eventMappings != null : !((Object)this$eventMappings).equals(other$eventMappings));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<EventMapping> $eventMappings = this.eventMappings;
        result = result * 59 + ($eventMappings == null ? 43 : ((Object)$eventMappings).hashCode());
        return result;
    }

    private DetermineEventForWebSocketsProcessor(List<EventMapping> eventMappings) {
        this.eventMappings = eventMappings;
    }
}

