/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websocketsevents;

import de.quantummaid.httpmaid.chains.ChainName;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.events.EventModule;
import de.quantummaid.httpmaid.events.ExternalEventMapping;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebSocket;
import de.quantummaid.httpmaid.websockets.WebSocketForEventFilter;
import de.quantummaid.httpmaid.websockets.WebsocketChainKeys;
import de.quantummaid.httpmaid.websockets.registry.WebSocketRegistry;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public final class WebSocketsExternalEventMapping
implements ExternalEventMapping {
    private final ChainName jumpTarget;
    private final WebSocketForEventFilter filter;
    private final BiConsumer<List<WebSocket>, MetaData> consumer;

    static ExternalEventMapping webSocketsExternalEventMapping(ChainName jumpTarget, WebSocketForEventFilter filter, BiConsumer<List<WebSocket>, MetaData> consumer) {
        Validators.validateNotNull((Object)jumpTarget, (String)"jumpTarget");
        Validators.validateNotNull((Object)filter, (String)"filter");
        Validators.validateNotNull(consumer, (String)"consumer");
        return new WebSocketsExternalEventMapping(jumpTarget, filter, consumer);
    }

    public Optional<ChainName> jumpTarget() {
        return Optional.of(this.jumpTarget);
    }

    public void apply(MetaData metaData) {
        Object event = ((Optional)metaData.get(EventModule.RECEIVED_EVENT)).orElseThrow();
        WebSocketRegistry registry = (WebSocketRegistry)metaData.get(WebsocketChainKeys.WEBSOCKET_REGISTRY);
        List webSockets = registry.allActiveWebSockets().stream().filter(webSocket -> {
            MetaData temporaryMetaData = MetaData.emptyMetaData();
            webSocket.savedMetaDataEntries().restoreTo(temporaryMetaData);
            return this.filter.test(temporaryMetaData, event);
        }).collect(Collectors.toList());
        this.consumer.accept(webSockets, metaData);
    }

    public void handle(Map<String, Object> event) {
    }

    public String toString() {
        return "WebSocketsExternalEventMapping(jumpTarget=" + this.jumpTarget + ", filter=" + this.filter + ", consumer=" + this.consumer + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebSocketsExternalEventMapping)) {
            return false;
        }
        WebSocketsExternalEventMapping other = (WebSocketsExternalEventMapping)o;
        ChainName this$jumpTarget = this.jumpTarget;
        ChainName other$jumpTarget = other.jumpTarget;
        if (this$jumpTarget == null ? other$jumpTarget != null : !this$jumpTarget.equals(other$jumpTarget)) {
            return false;
        }
        WebSocketForEventFilter this$filter = this.filter;
        WebSocketForEventFilter other$filter = other.filter;
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        BiConsumer<List<WebSocket>, MetaData> this$consumer = this.consumer;
        BiConsumer<List<WebSocket>, MetaData> other$consumer = other.consumer;
        return !(this$consumer == null ? other$consumer != null : !this$consumer.equals(other$consumer));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ChainName $jumpTarget = this.jumpTarget;
        result = result * 59 + ($jumpTarget == null ? 43 : $jumpTarget.hashCode());
        WebSocketForEventFilter $filter = this.filter;
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        BiConsumer<List<WebSocket>, MetaData> $consumer = this.consumer;
        result = result * 59 + ($consumer == null ? 43 : $consumer.hashCode());
        return result;
    }

    private WebSocketsExternalEventMapping(ChainName jumpTarget, WebSocketForEventFilter filter, BiConsumer<List<WebSocket>, MetaData> consumer) {
        this.jumpTarget = jumpTarget;
        this.filter = filter;
        this.consumer = consumer;
    }
}

