/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websocketsevents;

import de.quantummaid.eventmaid.processingContext.EventType;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Optional;
import java.util.function.Predicate;

public final class EventMapping {
    private final EventType eventType;
    private final Predicate<MetaData> predicate;

    static EventMapping eventMapping(EventType eventType, Predicate<MetaData> predicate) {
        Validators.validateNotNull((Object)eventType, (String)"eventType");
        Validators.validateNotNull(predicate, (String)"predicate");
        return new EventMapping(eventType, predicate);
    }

    public Optional<EventType> getEventIfMatching(MetaData metaData) {
        if (this.predicate.test(metaData)) {
            return Optional.of(this.eventType);
        }
        return Optional.empty();
    }

    public String toString() {
        return "EventMapping(eventType=" + this.eventType + ", predicate=" + this.predicate + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventMapping)) {
            return false;
        }
        EventMapping other = (EventMapping)o;
        EventType this$eventType = this.eventType;
        EventType other$eventType = other.eventType;
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        Predicate<MetaData> this$predicate = this.predicate;
        Predicate<MetaData> other$predicate = other.predicate;
        return !(this$predicate == null ? other$predicate != null : !this$predicate.equals(other$predicate));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventType $eventType = this.eventType;
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        Predicate<MetaData> $predicate = this.predicate;
        result = result * 59 + ($predicate == null ? 43 : $predicate.hashCode());
        return result;
    }

    private EventMapping(EventType eventType, Predicate<MetaData> predicate) {
        this.eventType = eventType;
        this.predicate = predicate;
    }
}

