/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder;

import de.quantummaid.mapmaid.builder.MapMaidConfiguration;
import de.quantummaid.mapmaid.builder.MarshallerAndUnmarshaller;
import de.quantummaid.mapmaid.builder.MarshallerAutoloadingException;
import de.quantummaid.mapmaid.builder.autoload.ActualAutoloadable;
import de.quantummaid.mapmaid.builder.autoload.Autoloadable;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.Disambiguator;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.Disambiguators;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.DisambiguatorBuilder;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.NormalDisambiguator;
import de.quantummaid.mapmaid.mapper.marshalling.Marshaller;
import de.quantummaid.mapmaid.mapper.marshalling.MarshallingType;
import de.quantummaid.mapmaid.mapper.marshalling.Unmarshaller;
import de.quantummaid.mapmaid.mapper.marshalling.registry.MarshallerRegistry;
import de.quantummaid.mapmaid.mapper.marshalling.registry.UnmarshallerRegistry;
import de.quantummaid.mapmaid.mapper.marshalling.string.StringUnmarshaller;
import de.quantummaid.mapmaid.polymorphy.PolymorphicTypeIdentifierExtractor;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;

public final class AdvancedBuilder {
    private static final List<Autoloadable<MarshallerAndUnmarshaller<?>>> AUTOLOADABLE_MARSHALLERS = List.of(ActualAutoloadable.autoloadIfClassPresent("de.quantummaid.mapmaid.minimaljson.MinimalJsonMarshallerAndUnmarshaller"));
    private final DisambiguatorBuilder defaultDisambiguatorBuilder = DisambiguatorBuilder.defaultDisambiguatorBuilder();
    private final MapMaidConfiguration mapMaidConfiguration = MapMaidConfiguration.emptyMapMaidConfiguration();
    private Map<MarshallingType<?>, Marshaller<?>> marshallerMap = de.quantummaid.mapmaid.collections.Collection.smallMap();
    private Map<MarshallingType<?>, Unmarshaller<?>> unmarshallerMap = de.quantummaid.mapmaid.collections.Collection.smallMap();
    private boolean autoloadMarshallers = true;
    private List<MarshallerAndUnmarshaller<?>> autoloadedMarshallers = null;
    private Supplier<List<MarshallerAndUnmarshaller<?>>> autoloadMethod = this::autoloadMarshallers;

    public static AdvancedBuilder advancedBuilder() {
        return new AdvancedBuilder();
    }

    public AdvancedBuilder withTypeIdentifierKey(String typeIdentifierKey) {
        NotNullValidator.validateNotNull(typeIdentifierKey, "typeIdentifierKey");
        this.mapMaidConfiguration.setTypeIdentifierKey(typeIdentifierKey);
        return this;
    }

    public AdvancedBuilder withTypeIdentifierExtractor(PolymorphicTypeIdentifierExtractor extractor) {
        NotNullValidator.validateNotNull(extractor, "extractor");
        this.mapMaidConfiguration.setTypeIdentifierExtractor(extractor);
        return this;
    }

    public AdvancedBuilder withPreferredCustomPrimitiveFactoryName(String name) {
        this.defaultDisambiguatorBuilder.setPreferredCustomPrimitiveFactoryName(name);
        return this;
    }

    public AdvancedBuilder withPreferredCustomPrimitiveSerializationMethodName(String name) {
        this.defaultDisambiguatorBuilder.setPreferredCustomPrimitiveSerializationMethodName(name);
        return this;
    }

    public AdvancedBuilder withPreferredSerializedObjectFactoryName(String name) {
        this.defaultDisambiguatorBuilder.setPreferredSerializedObjectFactoryName(name);
        return this;
    }

    public AdvancedBuilder doNotAutoloadMarshallers() {
        this.autoloadMarshallers = false;
        return this;
    }

    public <M> AdvancedBuilder usingMarshaller(MarshallerAndUnmarshaller<M> marshallerAndUnmarshaller) {
        MarshallingType<M> marshallingType = marshallerAndUnmarshaller.marshallingType();
        Marshaller<M> marshaller = marshallerAndUnmarshaller.marshaller();
        Unmarshaller<M> unmarshaller = marshallerAndUnmarshaller.unmarshaller();
        return this.usingMarshaller(marshallingType, marshaller, unmarshaller);
    }

    public <M> AdvancedBuilder usingMarshaller(MarshallingType<M> marshallingType, Marshaller<M> marshaller, Unmarshaller<M> unmarshaller) {
        NotNullValidator.validateNotNull(marshaller, "marshaller");
        NotNullValidator.validateNotNull(unmarshaller, "unmarshaller");
        NotNullValidator.validateNotNull(marshallingType, "marshallingType");
        this.marshallerMap.put(marshallingType, marshaller);
        this.unmarshallerMap.put(marshallingType, unmarshaller);
        return this.doNotAutoloadMarshallers();
    }

    public AdvancedBuilder usingMarshaller(Map<MarshallingType<?>, Marshaller<?>> marshallerMap, Map<MarshallingType<?>, Unmarshaller<?>> unmarshallerMap) {
        this.marshallerMap = new HashMap(marshallerMap);
        this.unmarshallerMap = new HashMap(unmarshallerMap);
        return this.doNotAutoloadMarshallers();
    }

    public AdvancedBuilder usingJsonMarshaller(Marshaller<String> marshaller, StringUnmarshaller unmarshaller) {
        NotNullValidator.validateNotNull(marshaller, "jsonMarshaller");
        NotNullValidator.validateNotNull(unmarshaller, "jsonUnmarshaller");
        return this.usingMarshaller(MarshallingType.JSON, marshaller, unmarshaller);
    }

    public AdvancedBuilder usingJsonMarshaller(Marshaller<String> marshaller, Unmarshaller<String> unmarshaller) {
        NotNullValidator.validateNotNull(marshaller, "jsonMarshaller");
        NotNullValidator.validateNotNull(unmarshaller, "jsonUnmarshaller");
        return this.usingMarshaller(MarshallingType.JSON, marshaller, unmarshaller);
    }

    public AdvancedBuilder usingYamlMarshaller(Marshaller<String> marshaller, StringUnmarshaller unmarshaller) {
        NotNullValidator.validateNotNull(marshaller, "yamlMarshaller");
        NotNullValidator.validateNotNull(unmarshaller, "yamlUnmarshaller");
        return this.usingMarshaller(MarshallingType.YAML, marshaller, unmarshaller);
    }

    public AdvancedBuilder usingXmlMarshaller(Marshaller<String> marshaller, StringUnmarshaller unmarshaller) {
        NotNullValidator.validateNotNull(marshaller, "xmlMarshaller");
        NotNullValidator.validateNotNull(unmarshaller, "xmlUnmarshaller");
        return this.usingMarshaller(MarshallingType.XML, marshaller, unmarshaller);
    }

    Disambiguators buildDisambiguators() {
        NormalDisambiguator defaultDisambiguator = this.defaultDisambiguatorBuilder.build();
        Map<ResolvedType, Disambiguator> specialDisambiguators = de.quantummaid.mapmaid.collections.Collection.smallMap();
        return Disambiguators.disambiguators(defaultDisambiguator, specialDisambiguators);
    }

    MarshallerRegistry buildMarshallerRegistry() {
        if (this.autoloadMarshallers) {
            this.autoload();
            this.autoloadedMarshallers.forEach(autoloadableMarshaller -> {
                MarshallingType marshallingType = autoloadableMarshaller.marshallingType();
                Marshaller marshaller = autoloadableMarshaller.marshaller();
                this.marshallerMap.put(marshallingType, marshaller);
            });
        }
        return MarshallerRegistry.marshallerRegistry(this.marshallerMap);
    }

    UnmarshallerRegistry buildUnmarshallerRegistry() {
        if (this.autoloadMarshallers) {
            this.autoload();
            this.autoloadedMarshallers.forEach(autoloadableMarshaller -> {
                MarshallingType marshallingType = autoloadableMarshaller.marshallingType();
                Unmarshaller unmarshaller = autoloadableMarshaller.unmarshaller();
                this.unmarshallerMap.put(marshallingType, unmarshaller);
            });
        }
        return UnmarshallerRegistry.unmarshallerRegistry(this.unmarshallerMap);
    }

    MapMaidConfiguration mapMaidConfiguration() {
        return this.mapMaidConfiguration;
    }

    private void autoload() {
        if (this.autoloadedMarshallers == null) {
            this.autoloadedMarshallers = this.autoloadMethod.get();
        }
    }

    private List<MarshallerAndUnmarshaller<?>> autoloadMarshallers() {
        Map<MarshallingType, List<MarshallerAndUnmarshaller>> foundByMarshallingTypes = AUTOLOADABLE_MARSHALLERS.stream().map(Autoloadable::autoload).flatMap(Optional::stream).collect(Collectors.groupingBy(MarshallerAndUnmarshaller::marshallingType));
        MarshallingType[] conflicting = (MarshallingType[])foundByMarshallingTypes.values().stream().filter(val -> val.size() > 1).map(marshallerAndUnmarshallers -> (MarshallerAndUnmarshaller)marshallerAndUnmarshallers.get(0)).map(MarshallerAndUnmarshaller::marshallingType).toArray(MarshallingType[]::new);
        if (conflicting.length >= 1) {
            MarshallingType firstConflict = conflicting[0];
            throw MarshallerAutoloadingException.conflictingMarshallersForTypes(firstConflict, (Collection)foundByMarshallingTypes.get(firstConflict));
        }
        return foundByMarshallingTypes.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Generated
    public String toString() {
        return "AdvancedBuilder(defaultDisambiguatorBuilder=" + this.defaultDisambiguatorBuilder + ", mapMaidConfiguration=" + this.mapMaidConfiguration + ", marshallerMap=" + this.marshallerMap + ", unmarshallerMap=" + this.unmarshallerMap + ", autoloadMarshallers=" + this.autoloadMarshallers + ", autoloadedMarshallers=" + this.autoloadedMarshallers + ", autoloadMethod=" + this.autoloadMethod + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdvancedBuilder)) {
            return false;
        }
        AdvancedBuilder other = (AdvancedBuilder)o;
        if (this.autoloadMarshallers != other.autoloadMarshallers) {
            return false;
        }
        DisambiguatorBuilder this$defaultDisambiguatorBuilder = this.defaultDisambiguatorBuilder;
        DisambiguatorBuilder other$defaultDisambiguatorBuilder = other.defaultDisambiguatorBuilder;
        if (this$defaultDisambiguatorBuilder == null ? other$defaultDisambiguatorBuilder != null : !((Object)this$defaultDisambiguatorBuilder).equals(other$defaultDisambiguatorBuilder)) {
            return false;
        }
        MapMaidConfiguration this$mapMaidConfiguration = this.mapMaidConfiguration;
        MapMaidConfiguration other$mapMaidConfiguration = other.mapMaidConfiguration;
        if (this$mapMaidConfiguration == null ? other$mapMaidConfiguration != null : !this$mapMaidConfiguration.equals(other$mapMaidConfiguration)) {
            return false;
        }
        Map<MarshallingType<?>, Marshaller<?>> this$marshallerMap = this.marshallerMap;
        Map<MarshallingType<?>, Marshaller<?>> other$marshallerMap = other.marshallerMap;
        if (this$marshallerMap == null ? other$marshallerMap != null : !((Object)this$marshallerMap).equals(other$marshallerMap)) {
            return false;
        }
        Map<MarshallingType<?>, Unmarshaller<?>> this$unmarshallerMap = this.unmarshallerMap;
        Map<MarshallingType<?>, Unmarshaller<?>> other$unmarshallerMap = other.unmarshallerMap;
        if (this$unmarshallerMap == null ? other$unmarshallerMap != null : !((Object)this$unmarshallerMap).equals(other$unmarshallerMap)) {
            return false;
        }
        List<MarshallerAndUnmarshaller<?>> this$autoloadedMarshallers = this.autoloadedMarshallers;
        List<MarshallerAndUnmarshaller<?>> other$autoloadedMarshallers = other.autoloadedMarshallers;
        if (this$autoloadedMarshallers == null ? other$autoloadedMarshallers != null : !((Object)this$autoloadedMarshallers).equals(other$autoloadedMarshallers)) {
            return false;
        }
        Supplier<List<MarshallerAndUnmarshaller<?>>> this$autoloadMethod = this.autoloadMethod;
        Supplier<List<MarshallerAndUnmarshaller<?>>> other$autoloadMethod = other.autoloadMethod;
        return !(this$autoloadMethod == null ? other$autoloadMethod != null : !this$autoloadMethod.equals(other$autoloadMethod));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.autoloadMarshallers ? 79 : 97);
        DisambiguatorBuilder $defaultDisambiguatorBuilder = this.defaultDisambiguatorBuilder;
        result = result * 59 + ($defaultDisambiguatorBuilder == null ? 43 : ((Object)$defaultDisambiguatorBuilder).hashCode());
        MapMaidConfiguration $mapMaidConfiguration = this.mapMaidConfiguration;
        result = result * 59 + ($mapMaidConfiguration == null ? 43 : $mapMaidConfiguration.hashCode());
        Map<MarshallingType<?>, Marshaller<?>> $marshallerMap = this.marshallerMap;
        result = result * 59 + ($marshallerMap == null ? 43 : ((Object)$marshallerMap).hashCode());
        Map<MarshallingType<?>, Unmarshaller<?>> $unmarshallerMap = this.unmarshallerMap;
        result = result * 59 + ($unmarshallerMap == null ? 43 : ((Object)$unmarshallerMap).hashCode());
        List<MarshallerAndUnmarshaller<?>> $autoloadedMarshallers = this.autoloadedMarshallers;
        result = result * 59 + ($autoloadedMarshallers == null ? 43 : ((Object)$autoloadedMarshallers).hashCode());
        Supplier<List<MarshallerAndUnmarshaller<?>>> $autoloadMethod = this.autoloadMethod;
        result = result * 59 + ($autoloadMethod == null ? 43 : $autoloadMethod.hashCode());
        return result;
    }

    @Generated
    private AdvancedBuilder() {
    }
}

