/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.detection.customprimitive.deserialization;

import de.quantummaid.mapmaid.builder.detection.customprimitive.deserialization.CustomPrimitiveDeserializationDetector;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.customprimitives.CustomPrimitiveByConstructorDeserializer;
import de.quantummaid.mapmaid.shared.mapping.CustomPrimitiveMappings;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import de.quantummaid.reflectmaid.ClassType;
import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.resolver.ResolvedConstructor;
import de.quantummaid.reflectmaid.resolver.ResolvedParameter;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public final class ConstructorBasedCustomPrimitiveDeserializationDetector
implements CustomPrimitiveDeserializationDetector {
    private final CustomPrimitiveMappings mappings;

    public static CustomPrimitiveDeserializationDetector constructorBased(CustomPrimitiveMappings mappings) {
        NotNullValidator.validateNotNull(mappings, "mappings");
        return new ConstructorBasedCustomPrimitiveDeserializationDetector(mappings);
    }

    @Override
    public List<TypeDeserializer> detect(ResolvedType type) {
        if (!(type instanceof ClassType)) {
            return Collections.emptyList();
        }
        return this.fittingConstructors((ClassType)type).stream().map(constructor -> CustomPrimitiveByConstructorDeserializer.createDeserializer(type, constructor)).collect(Collectors.toList());
    }

    private List<ResolvedConstructor> fittingConstructors(ClassType type) {
        return type.constructors().stream().filter(constructor -> constructor.parameters().size() == 1).filter(constructor -> {
            ResolvedParameter parameterType = (ResolvedParameter)constructor.parameters().get(0);
            return this.mappings.isPrimitiveType(parameterType.type().assignableType());
        }).collect(Collectors.toList());
    }

    @Generated
    public String toString() {
        return "ConstructorBasedCustomPrimitiveDeserializationDetector(mappings=" + this.mappings + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConstructorBasedCustomPrimitiveDeserializationDetector)) {
            return false;
        }
        ConstructorBasedCustomPrimitiveDeserializationDetector other = (ConstructorBasedCustomPrimitiveDeserializationDetector)o;
        CustomPrimitiveMappings this$mappings = this.mappings;
        CustomPrimitiveMappings other$mappings = other.mappings;
        return !(this$mappings == null ? other$mappings != null : !((Object)this$mappings).equals(other$mappings));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CustomPrimitiveMappings $mappings = this.mappings;
        result = result * 59 + ($mappings == null ? 43 : ((Object)$mappings).hashCode());
        return result;
    }

    @Generated
    private ConstructorBasedCustomPrimitiveDeserializationDetector(CustomPrimitiveMappings mappings) {
        this.mappings = mappings;
    }
}

