/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.detection.serializedobject.deserialization;

import de.quantummaid.mapmaid.builder.detection.serializedobject.deserialization.SerializedObjectDeserializationDetector;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.MethodSerializedObjectDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.SerializedObjectDeserializer;
import de.quantummaid.reflectmaid.ClassType;
import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.resolver.ResolvedMethod;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public final class StaticMethodDeserializationDetector
implements SerializedObjectDeserializationDetector {
    public static SerializedObjectDeserializationDetector staticMethodBased() {
        return new StaticMethodDeserializationDetector();
    }

    @Override
    public List<SerializedObjectDeserializer> detect(ResolvedType type) {
        return StaticMethodDeserializationDetector.detectDeserializerMethods(type).stream().map(method -> MethodSerializedObjectDeserializer.methodDeserializer((ClassType)type, method)).collect(Collectors.toList());
    }

    private static List<ResolvedMethod> detectDeserializerMethods(ResolvedType type) {
        if (!(type instanceof ClassType)) {
            return Collections.emptyList();
        }
        ClassType classType = (ClassType)type;
        return classType.methods().stream().filter(resolvedMethod -> Modifier.isStatic(resolvedMethod.method().getModifiers())).filter(resolvedMethod -> {
            Optional resolvedType = resolvedMethod.returnType();
            Optional<Boolean> optional = resolvedType.map(type::equals);
            return optional.orElse(false);
        }).filter(resolvedMethod -> !resolvedMethod.parameters().isEmpty()).collect(Collectors.toList());
    }

    @Generated
    public String toString() {
        return "StaticMethodDeserializationDetector()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof StaticMethodDeserializationDetector;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    private StaticMethodDeserializationDetector() {
    }
}

