/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.disambiguator.normal;

import de.quantummaid.mapmaid.builder.kotlin.KotlinUtils;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.DisambiguationContext;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.preferences.Filter;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.preferences.FilterResult;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.customprimitives.CustomPrimitiveByConstructorDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.customprimitives.CustomPrimitiveByMethodDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.ConstructorSerializedObjectDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.MethodSerializedObjectDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.customprimitives.MethodCustomPrimitiveSerializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.SerializationField;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.queries.PublicFieldQuery;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.reflectmaid.resolver.ResolvedField;
import de.quantummaid.reflectmaid.resolver.ResolvedMethod;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class CommonFilters {
    private static final Pattern KOTLIN_COMPONENT_PATTERN = Pattern.compile("component[0-9]+");

    private CommonFilters() {
    }

    static Filter<TypeDeserializer, DisambiguationContext> ignoreNonPublicMethodsForCustomPrimitiveDeserialization() {
        return Filter.filterOfType(CustomPrimitiveByMethodDeserializer.class, (deserializer, context, containingType) -> {
            if (deserializer.method().isPublic()) {
                return FilterResult.allowed();
            }
            return FilterResult.denied("only public static methods are considered for deserialization");
        });
    }

    static Filter<TypeSerializer, DisambiguationContext> ignoreNonPublicMethodsForCustomPrimitiveSerialization() {
        return Filter.filterOfType(MethodCustomPrimitiveSerializer.class, (serializer, context, containingType) -> {
            if (serializer.method().isPublic()) {
                return FilterResult.allowed();
            }
            return FilterResult.denied("only public methods are considered for serialization");
        });
    }

    static Filter<TypeSerializer, DisambiguationContext> ignoreComponentMethodsForKotlinCustomPrimitiveSerialization() {
        return Filter.filterOfType(MethodCustomPrimitiveSerializer.class, (serializer, context, containingType) -> {
            if (!KotlinUtils.isKotlinClass(containingType)) {
                return FilterResult.allowed();
            }
            ResolvedMethod method = serializer.method();
            String methodName = method.name();
            Matcher matcher = KOTLIN_COMPONENT_PATTERN.matcher(methodName);
            if (matcher.matches()) {
                return FilterResult.denied("Kotlin generated component methods are not used for serialization");
            }
            return FilterResult.allowed();
        });
    }

    static Filter<TypeDeserializer, DisambiguationContext> ignoreNonPublicConstructorsForCustomPrimitiveDeserialization() {
        return Filter.filterOfType(CustomPrimitiveByConstructorDeserializer.class, (deserializer, context, containingType) -> {
            if (deserializer.constructor().isPublic()) {
                return FilterResult.allowed();
            }
            return FilterResult.denied("only public constructors are considered for deserialization");
        });
    }

    static Filter<TypeDeserializer, DisambiguationContext> ignoreNonPublicMethodsForSerializedObjectDeserialization() {
        return Filter.filterOfType(MethodSerializedObjectDeserializer.class, (deserializer, context, containingType) -> {
            if (deserializer.method().isPublic()) {
                return FilterResult.allowed();
            }
            return FilterResult.denied("only public static methods are considered for deserialization");
        });
    }

    static Filter<TypeDeserializer, DisambiguationContext> ignoreNonPublicConstructorsForSerializedObjectDeserialization() {
        return Filter.filterOfType(ConstructorSerializedObjectDeserializer.class, (deserializer, context, containingType) -> {
            if (deserializer.constructor().isPublic()) {
                return FilterResult.allowed();
            }
            return FilterResult.denied("only public constructors are considered for deserialization");
        });
    }

    static Filter<TypeSerializer, DisambiguationContext> nameOfSerializerMethodIsNot(String name) {
        return (serializer, context, containingType) -> {
            if (!(serializer instanceof MethodCustomPrimitiveSerializer)) {
                return FilterResult.allowed();
            }
            ResolvedMethod method = ((MethodCustomPrimitiveSerializer)serializer).method();
            boolean matchesName = method.name().equals(name);
            if (!matchesName) {
                return FilterResult.allowed();
            }
            return FilterResult.denied(String.format("method '%s' is not considered", name));
        };
    }

    static Filter<SerializationField, DisambiguationContext> ignoreInjectedFields() {
        return (serializationField, context, containingType) -> {
            TypeIdentifier type = serializationField.type();
            if (context.isInjected(type)) {
                return FilterResult.denied("fields whose type is registered as injection-only are not serialized");
            }
            return FilterResult.allowed();
        };
    }

    static Filter<SerializationField, DisambiguationContext> ignoreStaticFields() {
        return CommonFilters.ignoreFieldsThat(ResolvedField::isStatic, "static fields are not serialized");
    }

    static Filter<SerializationField, DisambiguationContext> ignoreTransientFields() {
        return CommonFilters.ignoreFieldsThat(ResolvedField::isTransient, "transient fields are not serialized");
    }

    static Filter<SerializationField, DisambiguationContext> ignoreNonPublicFields() {
        return CommonFilters.ignoreFieldsThat(resolvedField -> !resolvedField.isPublic(), "only public fields are serialized");
    }

    private static Filter<SerializationField, DisambiguationContext> ignoreFieldsThat(Predicate<ResolvedField> fieldPredicate, String message) {
        return (field, context, containingType) -> {
            if (!(field.getQuery() instanceof PublicFieldQuery)) {
                return FilterResult.allowed();
            }
            PublicFieldQuery query = (PublicFieldQuery)field.getQuery();
            ResolvedField resolvedField = query.field();
            if (fieldPredicate.test(resolvedField)) {
                return FilterResult.denied(message);
            }
            return FilterResult.allowed();
        };
    }
}

