/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.preferences;

import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public final class FilterResult {
    private final List<String> reasonsForDenial;

    public static FilterResult combined(List<FilterResult> results) {
        List<String> combinedReasons = results.stream().map(FilterResult::reasonsForDenial).flatMap(Collection::stream).collect(Collectors.toList());
        return new FilterResult(combinedReasons);
    }

    public static FilterResult allowed() {
        return new FilterResult(Collections.emptyList());
    }

    public static FilterResult denied(String reasonForDenial) {
        NotNullValidator.validateNotNull(reasonForDenial, "reasonForDenial");
        return new FilterResult(List.of(reasonForDenial));
    }

    public boolean isAllowed() {
        return this.reasonsForDenial.isEmpty();
    }

    public List<String> reasonsForDenial() {
        return Collections.unmodifiableList(this.reasonsForDenial);
    }

    @Generated
    public String toString() {
        return "FilterResult(reasonsForDenial=" + this.reasonsForDenial + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterResult)) {
            return false;
        }
        FilterResult other = (FilterResult)o;
        List<String> this$reasonsForDenial = this.reasonsForDenial;
        List<String> other$reasonsForDenial = other.reasonsForDenial;
        return !(this$reasonsForDenial == null ? other$reasonsForDenial != null : !((Object)this$reasonsForDenial).equals(other$reasonsForDenial));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $reasonsForDenial = this.reasonsForDenial;
        result = result * 59 + ($reasonsForDenial == null ? 43 : ((Object)$reasonsForDenial).hashCode());
        return result;
    }

    @Generated
    private FilterResult(List<String> reasonsForDenial) {
        this.reasonsForDenial = reasonsForDenial;
    }
}

