/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.symmetry.serializedobject;

import de.quantummaid.mapmaid.builder.detection.DetectionResult;
import de.quantummaid.mapmaid.builder.detection.serializedobject.SerializationFieldInstantiation;
import de.quantummaid.mapmaid.builder.detection.serializedobject.SerializationFieldOptions;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.DisambiguationContext;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.symmetry.serializedobject.Combinations;
import de.quantummaid.mapmaid.collections.Collection;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.SerializedObjectDeserializer;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public final class EquivalenceSignature
implements Comparable<EquivalenceSignature> {
    private final Map<String, TypeIdentifier> fields;

    public static List<EquivalenceSignature> allOfDeserializer(SerializedObjectDeserializer deserializer, DisambiguationContext context) {
        Map<String, TypeIdentifier> fields = deserializer.fields().fields();
        List<Map<String, TypeIdentifier>> combinations = EquivalenceSignature.combinations(fields, context);
        return combinations.stream().map(EquivalenceSignature::new).collect(Collectors.toList());
    }

    private static List<Map<String, TypeIdentifier>> combinations(Map<String, TypeIdentifier> fields, DisambiguationContext context) {
        List requiredKeys = Collection.smallList();
        List optionalKeys = Collection.smallList();
        fields.forEach((key, typeIdentifier) -> {
            if (context.isInjected((TypeIdentifier)typeIdentifier)) {
                optionalKeys.add(key);
            } else {
                requiredKeys.add(key);
            }
        });
        List keyCombinations = Combinations.allCombinations(requiredKeys, optionalKeys);
        return keyCombinations.stream().map(keys -> EquivalenceSignature.subMap(keys, fields)).collect(Collectors.toList());
    }

    public Optional<SerializationFieldInstantiation> match(SerializationFieldOptions serializer) {
        DetectionResult<SerializationFieldInstantiation> instance = serializer.instantiate(this.fields);
        if (instance.isFailure()) {
            return Optional.empty();
        }
        return Optional.of(instance.result());
    }

    public int size() {
        return this.fields.size();
    }

    @Override
    public int compareTo(EquivalenceSignature other) {
        Integer mySize = this.fields.size();
        Integer otherSize = other.fields.size();
        return mySize.compareTo(otherSize) * -1;
    }

    private static Map<String, TypeIdentifier> subMap(List<String> keys, Map<String, TypeIdentifier> map) {
        HashMap<String, TypeIdentifier> subMap = new HashMap<String, TypeIdentifier>(keys.size());
        keys.forEach(key -> {
            TypeIdentifier typeIdentifier = (TypeIdentifier)map.get(key);
            subMap.put((String)key, typeIdentifier);
        });
        return subMap;
    }

    @Generated
    public String toString() {
        return "EquivalenceSignature(fields=" + this.fields + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EquivalenceSignature)) {
            return false;
        }
        EquivalenceSignature other = (EquivalenceSignature)o;
        Map<String, TypeIdentifier> this$fields = this.fields;
        Map<String, TypeIdentifier> other$fields = other.fields;
        return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, TypeIdentifier> $fields = this.fields;
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        return result;
    }

    @Generated
    private EquivalenceSignature(Map<String, TypeIdentifier> fields) {
        this.fields = fields;
    }
}

