/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.processing.factories.collections;

import de.quantummaid.mapmaid.builder.MapMaidConfiguration;
import de.quantummaid.mapmaid.builder.resolving.Context;
import de.quantummaid.mapmaid.builder.resolving.processing.factories.StateFactory;
import de.quantummaid.mapmaid.builder.resolving.processing.factories.StateFactoryResult;
import de.quantummaid.mapmaid.builder.resolving.processing.factories.collections.CollectionInformation;
import de.quantummaid.mapmaid.builder.resolving.processing.signals.AddManualDeserializerSignal;
import de.quantummaid.mapmaid.builder.resolving.processing.signals.AddManualSerializerSignal;
import de.quantummaid.mapmaid.builder.resolving.states.detected.Unreasoned;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.collections.ListCollectionDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.collections.ListCollectionSerializer;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.reflectmaid.ClassType;
import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.TypeVariableName;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class NativeJavaCollectionDefinitionFactory
implements StateFactory {
    private final Map<Class<?>, CollectionInformation> collectionInformations = CollectionInformation.collectionInformations();

    public static NativeJavaCollectionDefinitionFactory nativeJavaCollectionsFactory() {
        return new NativeJavaCollectionDefinitionFactory();
    }

    @Override
    public Optional<StateFactoryResult> create(TypeIdentifier typeIdentifier, Context context, MapMaidConfiguration configuration) {
        if (typeIdentifier.isVirtual()) {
            return Optional.empty();
        }
        ResolvedType type = typeIdentifier.getRealType();
        if (!this.collectionInformations.containsKey(type.assignableType())) {
            return Optional.empty();
        }
        if (type.typeParameters().size() != 1) {
            throw new UnsupportedOperationException(String.format("This should never happen. A collection of type '%s' has more than one type parameter", type.description()));
        }
        ResolvedType genericType = ((ClassType)type).typeParameter(TypeVariableName.typeVariableName((String)"E"));
        CollectionInformation collectionInformation = this.collectionInformations.get(type.assignableType());
        return Optional.of(StateFactoryResult.stateFactoryResult(Unreasoned.unreasoned(context), List.of(AddManualSerializerSignal.addManualSerializer(typeIdentifier, ListCollectionSerializer.listSerializer(genericType)), AddManualDeserializerSignal.addManualDeserializer(typeIdentifier, ListCollectionDeserializer.listDeserializer(genericType, collectionInformation.mapper())))));
    }
}

