/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.processing.factories.kotlin;

import de.quantummaid.mapmaid.builder.MapMaidConfiguration;
import de.quantummaid.mapmaid.builder.kotlin.KotlinUtils;
import de.quantummaid.mapmaid.builder.resolving.Context;
import de.quantummaid.mapmaid.builder.resolving.processing.factories.StateFactory;
import de.quantummaid.mapmaid.builder.resolving.processing.factories.StateFactoryResult;
import de.quantummaid.mapmaid.builder.resolving.processing.signals.AddManualDeserializerSignal;
import de.quantummaid.mapmaid.builder.resolving.processing.signals.AddManualSerializerSignal;
import de.quantummaid.mapmaid.builder.resolving.states.detected.Unreasoned;
import de.quantummaid.mapmaid.collections.BiMap;
import de.quantummaid.mapmaid.polymorphy.PolymorphicDeserializer;
import de.quantummaid.mapmaid.polymorphy.PolymorphicSerializer;
import de.quantummaid.mapmaid.polymorphy.PolymorphicUtils;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;

public final class KotlinSealedClassFactory
implements StateFactory {
    public static KotlinSealedClassFactory kotlinSealedClassFactory() {
        return new KotlinSealedClassFactory();
    }

    @Override
    public Optional<StateFactoryResult> create(TypeIdentifier type, Context context, MapMaidConfiguration mapMaidConfiguration) {
        if (type.isVirtual()) {
            return Optional.empty();
        }
        ResolvedType resolvedType = type.getRealType();
        if (!KotlinUtils.isKotlinClass(resolvedType)) {
            return Optional.empty();
        }
        KClass<?> kotlinClass = KotlinUtils.kotlinClassOf(resolvedType);
        if (!kotlinClass.isSealed()) {
            return Optional.empty();
        }
        List<TypeIdentifier> subtypes = kotlinClass.getSealedSubclasses().stream().map(JvmClassMappingKt::getJavaClass).map(TypeIdentifier::typeIdentifierFor).collect(Collectors.toList());
        BiMap<String, TypeIdentifier> nameToType = PolymorphicUtils.nameToIdentifier(subtypes, mapMaidConfiguration);
        PolymorphicSerializer serializer = PolymorphicSerializer.polymorphicSerializer(type, nameToType, "type");
        PolymorphicDeserializer deserializer = PolymorphicDeserializer.polymorphicDeserializer(type, nameToType, "type");
        return Optional.of(StateFactoryResult.stateFactoryResult(Unreasoned.unreasoned(context), List.of(AddManualSerializerSignal.addManualSerializer(type, serializer), AddManualDeserializerSignal.addManualDeserializer(type, deserializer))));
    }
}

