/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.requirements;

import de.quantummaid.mapmaid.builder.resolving.requirements.DetectionRequirements;
import de.quantummaid.mapmaid.debug.Reason;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public final class DetectionRequirementReasons {
    public final List<Reason> serializationReasons;
    public final List<Reason> deserializationReasons;
    private final List<Reason> objectEnforcingReasons;
    private final List<Reason> inlinedPrimitiveReasons;
    private final TypeSerializer manuallyConfiguredSerializer;
    private final TypeDeserializer manuallyConfiguredDeserializer;

    public static DetectionRequirementReasons empty() {
        return new DetectionRequirementReasons(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null);
    }

    public DetectionRequirementReasons setManuallyConfiguredSerializer(TypeSerializer manuallyConfiguredSerializer) {
        return new DetectionRequirementReasons(this.serializationReasons, this.deserializationReasons, this.objectEnforcingReasons, this.inlinedPrimitiveReasons, manuallyConfiguredSerializer, this.manuallyConfiguredDeserializer);
    }

    public DetectionRequirementReasons setManuallyConfiguredDeserializer(TypeDeserializer manuallyConfiguredDeserializer) {
        return new DetectionRequirementReasons(this.serializationReasons, this.deserializationReasons, this.objectEnforcingReasons, this.inlinedPrimitiveReasons, this.manuallyConfiguredSerializer, manuallyConfiguredDeserializer);
    }

    public DetectionRequirementReasons addSerialization(Reason reason) {
        ArrayList<Reason> newSerializationReasons = new ArrayList<Reason>(this.serializationReasons);
        newSerializationReasons.add(reason);
        return new DetectionRequirementReasons(newSerializationReasons, this.deserializationReasons, this.objectEnforcingReasons, this.inlinedPrimitiveReasons, this.manuallyConfiguredSerializer, this.manuallyConfiguredDeserializer);
    }

    public DetectionRequirementReasons removeSerialization(Reason reason) {
        ArrayList<Reason> newSerializationReasons = new ArrayList<Reason>(this.serializationReasons);
        newSerializationReasons.remove(reason);
        return new DetectionRequirementReasons(newSerializationReasons, this.deserializationReasons, this.objectEnforcingReasons, this.inlinedPrimitiveReasons, this.manuallyConfiguredSerializer, this.manuallyConfiguredDeserializer);
    }

    public DetectionRequirementReasons addDeserialization(Reason reason) {
        ArrayList<Reason> newDeserializationReasons = new ArrayList<Reason>(this.deserializationReasons);
        newDeserializationReasons.add(reason);
        return new DetectionRequirementReasons(this.serializationReasons, newDeserializationReasons, this.objectEnforcingReasons, this.inlinedPrimitiveReasons, this.manuallyConfiguredSerializer, this.manuallyConfiguredDeserializer);
    }

    public DetectionRequirementReasons removeDeserialization(Reason reason) {
        ArrayList<Reason> newDeserializationReasons = new ArrayList<Reason>(this.deserializationReasons);
        newDeserializationReasons.remove(reason);
        return new DetectionRequirementReasons(this.serializationReasons, newDeserializationReasons, this.objectEnforcingReasons, this.inlinedPrimitiveReasons, this.manuallyConfiguredSerializer, this.manuallyConfiguredDeserializer);
    }

    public DetectionRequirementReasons enforceObject(Reason reason) {
        ArrayList<Reason> newObjectEnforcingReasons = new ArrayList<Reason>(this.objectEnforcingReasons);
        newObjectEnforcingReasons.add(reason);
        return new DetectionRequirementReasons(this.serializationReasons, this.deserializationReasons, newObjectEnforcingReasons, this.inlinedPrimitiveReasons, this.manuallyConfiguredSerializer, this.manuallyConfiguredDeserializer);
    }

    public boolean hasChanged(DetectionRequirementReasons old) {
        DetectionRequirements oldDetectionRequirements;
        DetectionRequirements currentDetectionRequirements = this.detectionRequirements();
        return !currentDetectionRequirements.equals(oldDetectionRequirements = old.detectionRequirements());
    }

    public DetectionRequirements detectionRequirements() {
        return DetectionRequirements.detectionRequirements(!this.serializationReasons.isEmpty(), !this.deserializationReasons.isEmpty(), !this.objectEnforcingReasons.isEmpty(), !this.inlinedPrimitiveReasons.isEmpty(), this.manuallyConfiguredSerializer, this.manuallyConfiguredDeserializer);
    }

    public boolean isUnreasoned() {
        return this.serializationReasons.isEmpty() && this.deserializationReasons.isEmpty();
    }

    public String summary() {
        return String.format("serialization: %d, deserialization: %d, object: %d, primitive: %d, manual serializer: %s, manual deserializer: %s", this.serializationReasons.size(), this.deserializationReasons.size(), this.objectEnforcingReasons.size(), this.inlinedPrimitiveReasons.size(), this.manuallyConfiguredSerializer != null, this.manuallyConfiguredDeserializer != null);
    }

    @Generated
    public String toString() {
        return "DetectionRequirementReasons(serializationReasons=" + this.serializationReasons + ", deserializationReasons=" + this.deserializationReasons + ", objectEnforcingReasons=" + this.objectEnforcingReasons + ", inlinedPrimitiveReasons=" + this.inlinedPrimitiveReasons + ", manuallyConfiguredSerializer=" + this.manuallyConfiguredSerializer + ", manuallyConfiguredDeserializer=" + this.manuallyConfiguredDeserializer + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetectionRequirementReasons)) {
            return false;
        }
        DetectionRequirementReasons other = (DetectionRequirementReasons)o;
        List<Reason> this$serializationReasons = this.serializationReasons;
        List<Reason> other$serializationReasons = other.serializationReasons;
        if (this$serializationReasons == null ? other$serializationReasons != null : !((Object)this$serializationReasons).equals(other$serializationReasons)) {
            return false;
        }
        List<Reason> this$deserializationReasons = this.deserializationReasons;
        List<Reason> other$deserializationReasons = other.deserializationReasons;
        if (this$deserializationReasons == null ? other$deserializationReasons != null : !((Object)this$deserializationReasons).equals(other$deserializationReasons)) {
            return false;
        }
        List<Reason> this$objectEnforcingReasons = this.objectEnforcingReasons;
        List<Reason> other$objectEnforcingReasons = other.objectEnforcingReasons;
        if (this$objectEnforcingReasons == null ? other$objectEnforcingReasons != null : !((Object)this$objectEnforcingReasons).equals(other$objectEnforcingReasons)) {
            return false;
        }
        List<Reason> this$inlinedPrimitiveReasons = this.inlinedPrimitiveReasons;
        List<Reason> other$inlinedPrimitiveReasons = other.inlinedPrimitiveReasons;
        if (this$inlinedPrimitiveReasons == null ? other$inlinedPrimitiveReasons != null : !((Object)this$inlinedPrimitiveReasons).equals(other$inlinedPrimitiveReasons)) {
            return false;
        }
        TypeSerializer this$manuallyConfiguredSerializer = this.manuallyConfiguredSerializer;
        TypeSerializer other$manuallyConfiguredSerializer = other.manuallyConfiguredSerializer;
        if (this$manuallyConfiguredSerializer == null ? other$manuallyConfiguredSerializer != null : !this$manuallyConfiguredSerializer.equals(other$manuallyConfiguredSerializer)) {
            return false;
        }
        TypeDeserializer this$manuallyConfiguredDeserializer = this.manuallyConfiguredDeserializer;
        TypeDeserializer other$manuallyConfiguredDeserializer = other.manuallyConfiguredDeserializer;
        return !(this$manuallyConfiguredDeserializer == null ? other$manuallyConfiguredDeserializer != null : !this$manuallyConfiguredDeserializer.equals(other$manuallyConfiguredDeserializer));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Reason> $serializationReasons = this.serializationReasons;
        result = result * 59 + ($serializationReasons == null ? 43 : ((Object)$serializationReasons).hashCode());
        List<Reason> $deserializationReasons = this.deserializationReasons;
        result = result * 59 + ($deserializationReasons == null ? 43 : ((Object)$deserializationReasons).hashCode());
        List<Reason> $objectEnforcingReasons = this.objectEnforcingReasons;
        result = result * 59 + ($objectEnforcingReasons == null ? 43 : ((Object)$objectEnforcingReasons).hashCode());
        List<Reason> $inlinedPrimitiveReasons = this.inlinedPrimitiveReasons;
        result = result * 59 + ($inlinedPrimitiveReasons == null ? 43 : ((Object)$inlinedPrimitiveReasons).hashCode());
        TypeSerializer $manuallyConfiguredSerializer = this.manuallyConfiguredSerializer;
        result = result * 59 + ($manuallyConfiguredSerializer == null ? 43 : $manuallyConfiguredSerializer.hashCode());
        TypeDeserializer $manuallyConfiguredDeserializer = this.manuallyConfiguredDeserializer;
        result = result * 59 + ($manuallyConfiguredDeserializer == null ? 43 : $manuallyConfiguredDeserializer.hashCode());
        return result;
    }

    @Generated
    private DetectionRequirementReasons(List<Reason> serializationReasons, List<Reason> deserializationReasons, List<Reason> objectEnforcingReasons, List<Reason> inlinedPrimitiveReasons, TypeSerializer manuallyConfiguredSerializer, TypeDeserializer manuallyConfiguredDeserializer) {
        this.serializationReasons = serializationReasons;
        this.deserializationReasons = deserializationReasons;
        this.objectEnforcingReasons = objectEnforcingReasons;
        this.inlinedPrimitiveReasons = inlinedPrimitiveReasons;
        this.manuallyConfiguredSerializer = manuallyConfiguredSerializer;
        this.manuallyConfiguredDeserializer = manuallyConfiguredDeserializer;
    }
}

