/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.requirements;

import de.quantummaid.mapmaid.builder.detection.DetectionResult;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.DisambiguationResult;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import java.util.Optional;
import lombok.Generated;

public final class DetectionRequirements {
    public final boolean serialization;
    public final boolean deserialization;
    public final boolean hasToBeObject;
    public final boolean hasToBeInlinedPrimitive;
    private final TypeSerializer manuallyConfiguredSerializer;
    private final TypeDeserializer manuallyConfiguredDeserializer;

    static DetectionRequirements detectionRequirements(boolean serialization, boolean deserialization, boolean hasToBeObject, boolean hasToBeInlinedPrimitive, TypeSerializer manuallyConfiguredSerializer, TypeDeserializer manuallyConfiguredDeserializer) {
        return new DetectionRequirements(serialization, deserialization, hasToBeObject, hasToBeInlinedPrimitive, manuallyConfiguredSerializer, manuallyConfiguredDeserializer);
    }

    public boolean isUnreasoned() {
        return !this.serialization && !this.deserialization;
    }

    public boolean isSerializationOnly() {
        return this.serialization && !this.deserialization;
    }

    public boolean isDeserializationOnly() {
        return !this.serialization && this.deserialization;
    }

    public boolean isDuplex() {
        return this.serialization && this.deserialization;
    }

    public String describe() {
        if (this.isSerializationOnly()) {
            return "serialization";
        }
        if (this.isDeserializationOnly()) {
            return "deserialization";
        }
        if (this.isDuplex()) {
            return "duplex";
        }
        throw new UnsupportedOperationException();
    }

    public Optional<DetectionResult<DisambiguationResult>> fixedResult() {
        if (this.manuallyConfiguredSerializer != null || this.manuallyConfiguredDeserializer != null) {
            return Optional.of(DetectionResult.success(DisambiguationResult.disambiguationResult(this.manuallyConfiguredSerializer, this.manuallyConfiguredDeserializer)));
        }
        return Optional.empty();
    }

    @Generated
    public String toString() {
        return "DetectionRequirements(serialization=" + this.serialization + ", deserialization=" + this.deserialization + ", hasToBeObject=" + this.hasToBeObject + ", hasToBeInlinedPrimitive=" + this.hasToBeInlinedPrimitive + ", manuallyConfiguredSerializer=" + this.manuallyConfiguredSerializer + ", manuallyConfiguredDeserializer=" + this.manuallyConfiguredDeserializer + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetectionRequirements)) {
            return false;
        }
        DetectionRequirements other = (DetectionRequirements)o;
        if (this.serialization != other.serialization) {
            return false;
        }
        if (this.deserialization != other.deserialization) {
            return false;
        }
        if (this.hasToBeObject != other.hasToBeObject) {
            return false;
        }
        if (this.hasToBeInlinedPrimitive != other.hasToBeInlinedPrimitive) {
            return false;
        }
        TypeSerializer this$manuallyConfiguredSerializer = this.manuallyConfiguredSerializer;
        TypeSerializer other$manuallyConfiguredSerializer = other.manuallyConfiguredSerializer;
        if (this$manuallyConfiguredSerializer == null ? other$manuallyConfiguredSerializer != null : !this$manuallyConfiguredSerializer.equals(other$manuallyConfiguredSerializer)) {
            return false;
        }
        TypeDeserializer this$manuallyConfiguredDeserializer = this.manuallyConfiguredDeserializer;
        TypeDeserializer other$manuallyConfiguredDeserializer = other.manuallyConfiguredDeserializer;
        return !(this$manuallyConfiguredDeserializer == null ? other$manuallyConfiguredDeserializer != null : !this$manuallyConfiguredDeserializer.equals(other$manuallyConfiguredDeserializer));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.serialization ? 79 : 97);
        result = result * 59 + (this.deserialization ? 79 : 97);
        result = result * 59 + (this.hasToBeObject ? 79 : 97);
        result = result * 59 + (this.hasToBeInlinedPrimitive ? 79 : 97);
        TypeSerializer $manuallyConfiguredSerializer = this.manuallyConfiguredSerializer;
        result = result * 59 + ($manuallyConfiguredSerializer == null ? 43 : $manuallyConfiguredSerializer.hashCode());
        TypeDeserializer $manuallyConfiguredDeserializer = this.manuallyConfiguredDeserializer;
        result = result * 59 + ($manuallyConfiguredDeserializer == null ? 43 : $manuallyConfiguredDeserializer.hashCode());
        return result;
    }

    @Generated
    private DetectionRequirements(boolean serialization, boolean deserialization, boolean hasToBeObject, boolean hasToBeInlinedPrimitive, TypeSerializer manuallyConfiguredSerializer, TypeDeserializer manuallyConfiguredDeserializer) {
        this.serialization = serialization;
        this.deserialization = deserialization;
        this.hasToBeObject = hasToBeObject;
        this.hasToBeInlinedPrimitive = hasToBeInlinedPrimitive;
        this.manuallyConfiguredSerializer = manuallyConfiguredSerializer;
        this.manuallyConfiguredDeserializer = manuallyConfiguredDeserializer;
    }
}

