/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.collections;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import lombok.Generated;

public final class BiMap<A, B> {
    private final Map<A, B> byA;
    private final Map<B, A> byB;

    public static <A, B> BiMap<A, B> biMap(Map<A, B> map) {
        Map<Object, Object> byB = map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        return new BiMap<Object, Object>(map, byB);
    }

    public Optional<B> lookup(A key) {
        return Optional.ofNullable(this.byA.get(key));
    }

    public Optional<A> reverseLookup(B key) {
        return Optional.ofNullable(this.byB.get(key));
    }

    public int size() {
        return this.byA.size();
    }

    public void forEach(BiConsumer<? super A, ? super B> action) {
        this.byA.forEach(action);
    }

    public List<B> values() {
        return new ArrayList<B>(this.byA.values());
    }

    public List<A> keys() {
        return new ArrayList<A>(this.byA.keySet());
    }

    @Generated
    public String toString() {
        return "BiMap(byA=" + this.byA + ", byB=" + this.byB + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BiMap)) {
            return false;
        }
        BiMap other = (BiMap)o;
        Map<A, B> this$byA = this.byA;
        Map<A, B> other$byA = other.byA;
        if (this$byA == null ? other$byA != null : !((Object)this$byA).equals(other$byA)) {
            return false;
        }
        Map<B, A> this$byB = this.byB;
        Map<B, A> other$byB = other.byB;
        return !(this$byB == null ? other$byB != null : !((Object)this$byB).equals(other$byB));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<A, B> $byA = this.byA;
        result = result * 59 + ($byA == null ? 43 : ((Object)$byA).hashCode());
        Map<B, A> $byB = this.byB;
        result = result * 59 + ($byB == null ? 43 : ((Object)$byB).hashCode());
        return result;
    }

    @Generated
    private BiMap(Map<A, B> byA, Map<B, A> byB) {
        this.byA = byA;
        this.byB = byB;
    }
}

