/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.debug;

import de.quantummaid.mapmaid.builder.resolving.requirements.DetectionRequirementReasons;
import de.quantummaid.mapmaid.builder.resolving.requirements.DetectionRequirements;
import de.quantummaid.mapmaid.builder.resolving.requirements.RequirementsReducer;
import de.quantummaid.mapmaid.collections.Collection;
import de.quantummaid.mapmaid.debug.RequiredAction;
import de.quantummaid.mapmaid.debug.SubReasonProvider;
import de.quantummaid.mapmaid.debug.scaninformation.ActualScanInformation;
import de.quantummaid.mapmaid.debug.scaninformation.Reasons;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.SerializationField;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.SerializedObjectSerializer;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class ScanInformationBuilder {
    private final TypeIdentifier type;
    private DetectionRequirementReasons detectionRequirementReasons = DetectionRequirementReasons.empty();
    private final Map<TypeSerializer, List<String>> serializers;
    private final Map<SerializationField, List<String>> serializationFields;
    private final Map<TypeDeserializer, List<String>> deserializers;
    private TypeSerializer serializer;
    private TypeDeserializer deserializer;

    public static ScanInformationBuilder scanInformationBuilder(TypeIdentifier type) {
        return new ScanInformationBuilder(type, Collection.smallMap(), Collection.smallMap(), Collection.smallMap());
    }

    public void addSerializer(TypeSerializer serializer) {
        this.serializers.put(serializer, Collection.smallList());
    }

    public void addSerializationField(SerializationField field) {
        this.serializationFields.put(field, Collection.smallList());
    }

    public void addDeserializer(TypeDeserializer deserializer) {
        this.deserializers.put(deserializer, Collection.smallList());
    }

    public void resetScan() {
        this.serializers.clear();
        this.deserializers.clear();
    }

    public RequiredAction changeRequirements(RequirementsReducer reducer) {
        DetectionRequirementReasons newReasons;
        DetectionRequirementReasons oldReaons = this.detectionRequirementReasons;
        this.detectionRequirementReasons = newReasons = reducer.reduce(oldReaons);
        if (this.detectionRequirements().isUnreasoned()) {
            return RequiredAction.unreasoned();
        }
        if (oldReaons.hasChanged(newReasons)) {
            return RequiredAction.requirementsChanged();
        }
        return RequiredAction.nothingChanged();
    }

    public DetectionRequirementReasons detectionRequirementReasons() {
        return this.detectionRequirementReasons;
    }

    public DetectionRequirements detectionRequirements() {
        return this.detectionRequirementReasons.detectionRequirements();
    }

    public void ignoreAllOtherSerializers(TypeSerializer serializer, String reason) {
        this.serializers.forEach((current, reasons) -> {
            if (!current.equals(serializer)) {
                reasons.add(reason);
            }
        });
    }

    public void ignoreDeserializer(TypeDeserializer deserializer, String reason) {
        this.deserializers.get(deserializer).add(reason);
    }

    public void ignoreDeserializer(TypeDeserializer deserializer, List<String> reasons) {
        reasons.forEach(reason -> this.ignoreDeserializer(deserializer, (String)reason));
    }

    public void ignoreSerializer(TypeSerializer serializer, String reason) {
        this.serializers.get(serializer).add(reason);
    }

    public void ignoreSerializer(TypeSerializer serializer, List<String> reasons) {
        reasons.forEach(reason -> this.ignoreSerializer(serializer, (String)reason));
    }

    public void ignoreSerializationField(SerializationField field, List<String> reasons) {
        this.serializationFields.get(field).addAll(reasons);
    }

    public void ignoreSerializationField(SerializationField field, String reason) {
        this.serializationFields.get(field).add(reason);
    }

    public void ignoreAllOtherDeserializers(TypeDeserializer deserializer, String reason) {
        this.deserializers.forEach((current, reasons) -> {
            if (!current.equals(deserializer)) {
                reasons.add(reason);
            }
        });
    }

    public void ignore(Object object, String reason) {
        if (object instanceof SerializedObjectSerializer) {
            List<SerializationField> fields = ((SerializedObjectSerializer)object).fields().fields();
            fields.forEach(field -> this.ignoreSerializationField((SerializationField)field, reason));
        } else if (object instanceof TypeSerializer) {
            this.ignoreSerializer((TypeSerializer)object, reason);
        } else if (object instanceof TypeDeserializer) {
            this.ignoreDeserializer((TypeDeserializer)object, reason);
        } else if (object instanceof SerializationField) {
            this.ignoreSerializationField((SerializationField)object, reason);
        } else {
            throw new UnsupportedOperationException("This should never happen. Unknown object: " + object);
        }
    }

    public void setSerializer(TypeSerializer serializer) {
        this.serializer = serializer;
    }

    public void setDeserializer(TypeDeserializer deserializer) {
        this.deserializer = deserializer;
    }

    public ScanInformation build(SubReasonProvider serializationSubReasonProvider, SubReasonProvider deserializationSubReasonProvider) {
        if (this.serializer != null) {
            if (this.serializer instanceof SerializedObjectSerializer) {
                SerializedObjectSerializer serializedObjectSerializer = (SerializedObjectSerializer)this.serializer;
                serializedObjectSerializer.fields().fields().forEach(this.serializationFields::remove);
            } else {
                this.serializers.remove(this.serializer);
            }
        }
        if (this.deserializer != null) {
            this.deserializers.remove(this.deserializer);
        }
        Reasons reasons = Reasons.reasons(this.detectionRequirementReasons.deserializationReasons, this.detectionRequirementReasons.serializationReasons, serializationSubReasonProvider, deserializationSubReasonProvider);
        return ActualScanInformation.actualScanInformation(this.type, reasons, this.serializer, this.deserializer, this.serializers, this.serializationFields, this.deserializers);
    }

    @Generated
    public String toString() {
        return "ScanInformationBuilder(type=" + this.type + ", detectionRequirementReasons=" + this.detectionRequirementReasons + ", serializers=" + this.serializers + ", serializationFields=" + this.serializationFields + ", deserializers=" + this.deserializers + ", serializer=" + this.serializer + ", deserializer=" + this.deserializer + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScanInformationBuilder)) {
            return false;
        }
        ScanInformationBuilder other = (ScanInformationBuilder)o;
        TypeIdentifier this$type = this.type;
        TypeIdentifier other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        DetectionRequirementReasons this$detectionRequirementReasons = this.detectionRequirementReasons;
        DetectionRequirementReasons other$detectionRequirementReasons = other.detectionRequirementReasons;
        if (this$detectionRequirementReasons == null ? other$detectionRequirementReasons != null : !((Object)this$detectionRequirementReasons).equals(other$detectionRequirementReasons)) {
            return false;
        }
        Map<TypeSerializer, List<String>> this$serializers = this.serializers;
        Map<TypeSerializer, List<String>> other$serializers = other.serializers;
        if (this$serializers == null ? other$serializers != null : !((Object)this$serializers).equals(other$serializers)) {
            return false;
        }
        Map<SerializationField, List<String>> this$serializationFields = this.serializationFields;
        Map<SerializationField, List<String>> other$serializationFields = other.serializationFields;
        if (this$serializationFields == null ? other$serializationFields != null : !((Object)this$serializationFields).equals(other$serializationFields)) {
            return false;
        }
        Map<TypeDeserializer, List<String>> this$deserializers = this.deserializers;
        Map<TypeDeserializer, List<String>> other$deserializers = other.deserializers;
        if (this$deserializers == null ? other$deserializers != null : !((Object)this$deserializers).equals(other$deserializers)) {
            return false;
        }
        TypeSerializer this$serializer = this.serializer;
        TypeSerializer other$serializer = other.serializer;
        if (this$serializer == null ? other$serializer != null : !this$serializer.equals(other$serializer)) {
            return false;
        }
        TypeDeserializer this$deserializer = this.deserializer;
        TypeDeserializer other$deserializer = other.deserializer;
        return !(this$deserializer == null ? other$deserializer != null : !this$deserializer.equals(other$deserializer));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TypeIdentifier $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        DetectionRequirementReasons $detectionRequirementReasons = this.detectionRequirementReasons;
        result = result * 59 + ($detectionRequirementReasons == null ? 43 : ((Object)$detectionRequirementReasons).hashCode());
        Map<TypeSerializer, List<String>> $serializers = this.serializers;
        result = result * 59 + ($serializers == null ? 43 : ((Object)$serializers).hashCode());
        Map<SerializationField, List<String>> $serializationFields = this.serializationFields;
        result = result * 59 + ($serializationFields == null ? 43 : ((Object)$serializationFields).hashCode());
        Map<TypeDeserializer, List<String>> $deserializers = this.deserializers;
        result = result * 59 + ($deserializers == null ? 43 : ((Object)$deserializers).hashCode());
        TypeSerializer $serializer = this.serializer;
        result = result * 59 + ($serializer == null ? 43 : $serializer.hashCode());
        TypeDeserializer $deserializer = this.deserializer;
        result = result * 59 + ($deserializer == null ? 43 : $deserializer.hashCode());
        return result;
    }

    @Generated
    private ScanInformationBuilder(TypeIdentifier type, Map<TypeSerializer, List<String>> serializers, Map<SerializationField, List<String>> serializationFields, Map<TypeDeserializer, List<String>> deserializers) {
        this.type = type;
        this.serializers = serializers;
        this.serializationFields = serializationFields;
        this.deserializers = deserializers;
    }
}

