/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects;

import de.quantummaid.mapmaid.collections.Collection;
import de.quantummaid.mapmaid.debug.DebugInformation;
import de.quantummaid.mapmaid.mapper.deserialization.DeserializationFields;
import de.quantummaid.mapmaid.mapper.deserialization.DeserializerCallback;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ExceptionTracker;
import de.quantummaid.mapmaid.mapper.injector.Injector;
import de.quantummaid.mapmaid.mapper.schema.SchemaCallback;
import de.quantummaid.mapmaid.mapper.schema.SchemaSupport;
import de.quantummaid.mapmaid.mapper.universal.Universal;
import de.quantummaid.mapmaid.mapper.universal.UniversalNull;
import de.quantummaid.mapmaid.mapper.universal.UniversalObject;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.mapping.CustomPrimitiveMappings;
import java.util.List;
import java.util.Map;

public interface SerializedObjectDeserializer
extends TypeDeserializer {
    public static String createDescription(String deserializer) {
        return String.format("as serialized object using %s", deserializer);
    }

    @Override
    default public List<TypeIdentifier> requiredTypes() {
        return this.fields().referencedTypes();
    }

    public DeserializationFields fields();

    public Object deserialize(Map<String, Object> var1) throws Exception;

    @Override
    default public <T> T deserialize(Universal input, ExceptionTracker exceptionTracker, Injector injector, DeserializerCallback callback, CustomPrimitiveMappings customPrimitiveMappings, TypeIdentifier typeIdentifier, DebugInformation debugInformation) {
        if (input instanceof UniversalNull) {
            return null;
        }
        UniversalObject universalObject = TypeDeserializer.castSafely(input, UniversalObject.class, exceptionTracker, typeIdentifier, debugInformation);
        DeserializationFields deserializationFields = this.fields();
        Map<String, Object> elements = Collection.smallMap();
        for (Map.Entry<String, TypeIdentifier> entry : deserializationFields.fields().entrySet()) {
            String elementName = entry.getKey();
            TypeIdentifier elementType = entry.getValue();
            Universal elementInput = universalObject.getField(elementName).orElse(UniversalNull.universalNull());
            Object elementObject = callback.deserializeRecursive(elementInput, elementType, exceptionTracker.stepInto(elementName), injector, debugInformation);
            elements.put(elementName, elementObject);
        }
        if (exceptionTracker.validationResult().hasValidationErrors()) {
            return null;
        }
        try {
            return (T)this.deserialize(elements);
        }
        catch (Exception e) {
            String message = String.format("Exception calling deserialize(elements: %s) on deserializationMethod %s", elements, this);
            String deserializerInput = input.toNativeJava().toString();
            exceptionTracker.track(e, message, deserializerInput);
            return null;
        }
    }

    @Override
    default public Universal schema(SchemaCallback schemaCallback) {
        Map<String, TypeIdentifier> fields = this.fields().fields();
        return SchemaSupport.schemaForObject(fields, schemaCallback);
    }

    @Override
    default public int numberOfParameters() {
        return this.fields().size();
    }
}

