/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.deserialization.validation;

import de.quantummaid.mapmaid.collections.Collection;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

final class ThrowableRelativesLookup {
    private final List<Class<? extends Throwable>> relatives;

    static ThrowableRelativesLookup fromThrowable(Class<? extends Throwable> clazz) {
        List<Class<? extends Throwable>> relatives = Collection.smallList();
        ThrowableRelativesLookup.traverseRelatives(clazz, relatives);
        return new ThrowableRelativesLookup(relatives);
    }

    Class<? extends Throwable> closestRelativeFrom(java.util.Collection<Class<? extends Throwable>> assignableClasses) {
        for (Class<? extends Throwable> relative : this.relatives) {
            if (!assignableClasses.stream().anyMatch(relative::equals)) continue;
            return relative;
        }
        return null;
    }

    private static void traverseRelatives(Class<?> clazz, List<Class<? extends Throwable>> relatives) {
        if (Throwable.class.isAssignableFrom(clazz)) {
            relatives.add(clazz);
            Class<?> superclass = clazz.getSuperclass();
            Class<?>[] interfaces = clazz.getInterfaces();
            Arrays.stream(interfaces).forEach(interFace -> ThrowableRelativesLookup.traverseRelatives(interFace, relatives));
            if (superclass != null) {
                ThrowableRelativesLookup.traverseRelatives(superclass, relatives);
            }
        }
    }

    @Generated
    public String toString() {
        return "ThrowableRelativesLookup(relatives=" + this.relatives + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThrowableRelativesLookup)) {
            return false;
        }
        ThrowableRelativesLookup other = (ThrowableRelativesLookup)o;
        List<Class<? extends Throwable>> this$relatives = this.relatives;
        List<Class<? extends Throwable>> other$relatives = other.relatives;
        return !(this$relatives == null ? other$relatives != null : !((Object)this$relatives).equals(other$relatives));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Class<? extends Throwable>> $relatives = this.relatives;
        result = result * 59 + ($relatives == null ? 43 : ((Object)$relatives).hashCode());
        return result;
    }

    @Generated
    private ThrowableRelativesLookup(List<Class<? extends Throwable>> relatives) {
        this.relatives = relatives;
    }
}

