/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.marshalling;

import de.quantummaid.mapmaid.mapper.marshalling.MarshallingType;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.Set;
import java.util.stream.Collectors;

public final class UnsupportedMarshallingTypeException
extends RuntimeException {
    public UnsupportedMarshallingTypeException(String message) {
        super(message);
    }

    public static UnsupportedMarshallingTypeException unsupportedMarshallingTypeException(MarshallingType<?> required, Set<MarshallingType<?>> registered) {
        NotNullValidator.validateNotNull(required, "required");
        NotNullValidator.validateNotNull(registered, "registered");
        String knownTypes = registered.stream().map(MarshallingType::internalValueForMapping).collect(Collectors.joining("', '", "['", "']"));
        String message = String.format("Unsupported marshalling type '%s', known marshalling types are: %s", required.internalValueForMapping(), knownTypes);
        return new UnsupportedMarshallingTypeException(message);
    }
}

