/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.schema;

import de.quantummaid.mapmaid.mapper.schema.PrimitiveSchema;
import de.quantummaid.mapmaid.mapper.universal.Universal;
import java.util.LinkedHashMap;
import java.util.Map;

public final class PrimitiveSchemaMappings {
    private static final String STRING = "string";
    private static final String INTEGER = "integer";
    private static final String NUMBER = "number";
    private static final String BOOLEAN = "boolean";
    private static final Map<Class<?>, PrimitiveSchema> SCHEMATA = PrimitiveSchemaMappings.schemata();

    private PrimitiveSchemaMappings() {
    }

    public static Universal mapPrimitiveToSchema(Class<?> primitive) {
        PrimitiveSchema schema = SCHEMATA.get(primitive);
        if (schema == null) {
            throw new UnsupportedOperationException(String.format("Cannot map type '%s' to an OpenAPI type", primitive.getSimpleName()));
        }
        return schema.schema;
    }

    private static Map<Class<?>, PrimitiveSchema> schemata() {
        LinkedHashMap schemata = new LinkedHashMap();
        schemata.put(String.class, PrimitiveSchema.primitiveSchema(STRING));
        schemata.put(Integer.TYPE, PrimitiveSchema.primitiveSchema(INTEGER, "int32"));
        schemata.put(Integer.class, PrimitiveSchema.primitiveSchema(INTEGER, "int32"));
        schemata.put(Long.TYPE, PrimitiveSchema.primitiveSchema(INTEGER, "int64"));
        schemata.put(Long.class, PrimitiveSchema.primitiveSchema(INTEGER, "int64"));
        schemata.put(Short.TYPE, PrimitiveSchema.primitiveSchema(INTEGER));
        schemata.put(Short.class, PrimitiveSchema.primitiveSchema(INTEGER));
        schemata.put(Byte.TYPE, PrimitiveSchema.primitiveSchema(INTEGER));
        schemata.put(Byte.class, PrimitiveSchema.primitiveSchema(INTEGER));
        schemata.put(Double.TYPE, PrimitiveSchema.primitiveSchema(NUMBER, "double"));
        schemata.put(Double.class, PrimitiveSchema.primitiveSchema(NUMBER, "double"));
        schemata.put(Float.TYPE, PrimitiveSchema.primitiveSchema(NUMBER, "float"));
        schemata.put(Float.class, PrimitiveSchema.primitiveSchema(NUMBER, "float"));
        schemata.put(Boolean.TYPE, PrimitiveSchema.primitiveSchema(BOOLEAN));
        schemata.put(Boolean.class, PrimitiveSchema.primitiveSchema(BOOLEAN));
        return schemata;
    }
}

