/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.serialization.serializers.collections;

import de.quantummaid.mapmaid.debug.DebugInformation;
import de.quantummaid.mapmaid.mapper.schema.SchemaCallback;
import de.quantummaid.mapmaid.mapper.schema.SchemaSupport;
import de.quantummaid.mapmaid.mapper.serialization.SerializationCallback;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.mapmaid.mapper.serialization.tracker.SerializationTracker;
import de.quantummaid.mapmaid.mapper.universal.Universal;
import de.quantummaid.mapmaid.mapper.universal.UniversalCollection;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.mapping.CustomPrimitiveMappings;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public interface CollectionSerializer
extends TypeSerializer {
    public List<Object> collectionAsList(Object var1);

    @Override
    default public Universal serialize(Object object, SerializationCallback callback, SerializationTracker tracker, CustomPrimitiveMappings customPrimitiveMappings, DebugInformation debugInformation) {
        TypeIdentifier contentType = this.contentType();
        List<Universal> list = this.collectionAsList(object).stream().map(element -> callback.serializeDefinition(contentType, element, tracker)).collect(Collectors.toList());
        return UniversalCollection.universalCollection(list);
    }

    @Override
    default public List<TypeIdentifier> requiredTypes() {
        return Collections.singletonList(this.contentType());
    }

    public TypeIdentifier contentType();

    @Override
    default public Universal schema(SchemaCallback schemaCallback) {
        TypeIdentifier contentType = this.contentType();
        return SchemaSupport.schemaForCollection(contentType, schemaCallback);
    }
}

