/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.universal;

import de.quantummaid.mapmaid.mapper.universal.UniversalCollection;
import de.quantummaid.mapmaid.mapper.universal.UniversalInjection;
import de.quantummaid.mapmaid.mapper.universal.UniversalNull;
import de.quantummaid.mapmaid.mapper.universal.UniversalObject;
import de.quantummaid.mapmaid.mapper.universal.UniversalPrimitive;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public interface Universal {
    public static String describe(Class<? extends Universal> type) {
        if (type == UniversalObject.class) {
            return "object";
        }
        if (type == UniversalCollection.class) {
            return "collection";
        }
        if (type == UniversalPrimitive.class) {
            return "string";
        }
        if (type == UniversalNull.class) {
            return "null";
        }
        return String.format("<injected %s>", type.getSimpleName());
    }

    public static Universal fromNativeJava(Object object) {
        if (Objects.isNull(object)) {
            return UniversalNull.universalNull();
        }
        if (UniversalPrimitive.isUniversalPrimitive(object)) {
            return UniversalPrimitive.universalPrimitive(object);
        }
        if (object instanceof List) {
            return UniversalCollection.universalCollectionFromNativeList((List)object);
        }
        if (object instanceof Map) {
            return UniversalObject.universalObjectFromNativeMap((Map)object);
        }
        return UniversalInjection.universalInjection(object);
    }

    public Object toNativeJava();
}

