/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.universal;

import de.quantummaid.mapmaid.mapper.universal.Universal;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public final class UniversalObject
implements Universal {
    private final Map<String, Universal> map;

    public static UniversalObject universalObjectFromNativeMap(Map<String, Object> map) {
        NotNullValidator.validateNotNull(map, "map");
        Map<String, Universal> mappedMap = map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Universal.fromNativeJava(entry.getValue())));
        return UniversalObject.universalObject(mappedMap);
    }

    public static UniversalObject universalObject(Map<String, Universal> map) {
        NotNullValidator.validateNotNull(map, "map");
        map.forEach((key, value) -> NotNullValidator.validateNotNull(value, key));
        return new UniversalObject(map);
    }

    public Optional<Universal> getField(String name) {
        NotNullValidator.validateNotNull(name, "name");
        if (!this.map.containsKey(name)) {
            return Optional.empty();
        }
        return Optional.of(this.map.get(name));
    }

    @Override
    public Object toNativeJava() {
        HashMap nativeMap = new HashMap(this.map.size());
        this.map.forEach((key, value) -> nativeMap.put(key, value.toNativeJava()));
        return nativeMap;
    }

    @Generated
    public String toString() {
        return "UniversalObject(map=" + this.map + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UniversalObject)) {
            return false;
        }
        UniversalObject other = (UniversalObject)o;
        Map<String, Universal> this$map = this.map;
        Map<String, Universal> other$map = other.map;
        return !(this$map == null ? other$map != null : !((Object)this$map).equals(other$map));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Universal> $map = this.map;
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        return result;
    }

    @Generated
    private UniversalObject(Map<String, Universal> map) {
        this.map = map;
    }
}

