/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.polymorphy;

import de.quantummaid.mapmaid.collections.BiMap;
import de.quantummaid.mapmaid.debug.DebugInformation;
import de.quantummaid.mapmaid.mapper.schema.SchemaCallback;
import de.quantummaid.mapmaid.mapper.schema.SchemaSupport;
import de.quantummaid.mapmaid.mapper.serialization.SerializationCallback;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.mapmaid.mapper.serialization.tracker.SerializationTracker;
import de.quantummaid.mapmaid.mapper.universal.Universal;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.mapping.CustomPrimitiveMappings;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class PolymorphicSerializer
implements TypeSerializer {
    private final TypeIdentifier superType;
    private final BiMap<String, TypeIdentifier> nameToType;
    private final String typeField;

    public static PolymorphicSerializer polymorphicSerializer(TypeIdentifier superType, BiMap<String, TypeIdentifier> nameToType, String typeField) {
        return new PolymorphicSerializer(superType, nameToType, typeField);
    }

    @Override
    public List<TypeIdentifier> requiredTypes() {
        return this.nameToType.values();
    }

    @Override
    public Universal serialize(Object object, SerializationCallback callback, SerializationTracker tracker, CustomPrimitiveMappings customPrimitiveMappings, DebugInformation debugInformation) {
        TypeIdentifier implementationType = TypeIdentifier.typeIdentifierFor(object.getClass());
        Universal universal = callback.serializeDefinition(implementationType, object, SerializationTracker.serializationTracker());
        Map immutableMap = (Map)universal.toNativeJava();
        LinkedHashMap<String, String> mutableMap = new LinkedHashMap<String, String>(immutableMap);
        String type = this.nameToType.reverseLookup(implementationType).orElseThrow(() -> new IllegalArgumentException(String.format("Unknown event of type '%s'", implementationType.description())));
        mutableMap.put(this.typeField, type);
        return Universal.fromNativeJava(mutableMap);
    }

    @Override
    public boolean forcesDependenciesToBeObjects() {
        return true;
    }

    @Override
    public String description() {
        return String.format("polymorphic serializer for %s", this.superType.description());
    }

    @Override
    public Universal schema(SchemaCallback schemaCallback) {
        return SchemaSupport.schemaForPolymorphicParent(this.nameToType, this.typeField, schemaCallback);
    }

    @Generated
    private PolymorphicSerializer(TypeIdentifier superType, BiMap<String, TypeIdentifier> nameToType, String typeField) {
        this.superType = superType;
        this.nameToType = nameToType;
        this.typeField = typeField;
    }
}

