/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.customtypes.serializedobject;

import de.quantummaid.mapmaid.builder.customtypes.serializedobject.CustomDeserializationField;
import de.quantummaid.mapmaid.builder.customtypes.serializedobject.InvocableDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.DeserializationFields;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.SerializedObjectDeserializer;
import de.quantummaid.mapmaid.shared.identifier.RealTypeIdentifier;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class CustomDeserializer
implements SerializedObjectDeserializer {
    private final InvocableDeserializer<?> invocableDeserializer;
    private final List<CustomDeserializationField> fields;
    private final DeserializationFields deserializationFields;

    public static CustomDeserializer userProvidedDeserializer(InvocableDeserializer<?> invocableDeserializer, List<CustomDeserializationField> fields) {
        Map<String, TypeIdentifier> fieldMap = fields.stream().collect(Collectors.toMap(CustomDeserializationField::name, customDeserializationField -> RealTypeIdentifier.realTypeIdentifier(customDeserializationField.type())));
        DeserializationFields deserializationFields = DeserializationFields.deserializationFields(fieldMap);
        return new CustomDeserializer(invocableDeserializer, fields, deserializationFields);
    }

    @Override
    public DeserializationFields fields() {
        return this.deserializationFields;
    }

    @Override
    public Object deserialize(Map<String, Object> elements) {
        Object[] arguments = new Object[this.fields.size()];
        int i = 0;
        for (CustomDeserializationField field : this.fields) {
            String name = field.name();
            arguments[i] = elements.get(name);
            ++i;
        }
        return this.invocableDeserializer.invoke(arguments);
    }

    @Override
    public String description() {
        return "user provided";
    }

    public String toString() {
        return "CustomDeserializer(invocableDeserializer=" + this.invocableDeserializer + ", fields=" + this.fields + ", deserializationFields=" + this.deserializationFields + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomDeserializer)) {
            return false;
        }
        CustomDeserializer other = (CustomDeserializer)o;
        InvocableDeserializer<?> this$invocableDeserializer = this.invocableDeserializer;
        InvocableDeserializer<?> other$invocableDeserializer = other.invocableDeserializer;
        if (this$invocableDeserializer == null ? other$invocableDeserializer != null : !this$invocableDeserializer.equals(other$invocableDeserializer)) {
            return false;
        }
        List<CustomDeserializationField> this$fields = this.fields;
        List<CustomDeserializationField> other$fields = other.fields;
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        DeserializationFields this$deserializationFields = this.deserializationFields;
        DeserializationFields other$deserializationFields = other.deserializationFields;
        return !(this$deserializationFields == null ? other$deserializationFields != null : !((Object)this$deserializationFields).equals(other$deserializationFields));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InvocableDeserializer<?> $invocableDeserializer = this.invocableDeserializer;
        result = result * 59 + ($invocableDeserializer == null ? 43 : $invocableDeserializer.hashCode());
        List<CustomDeserializationField> $fields = this.fields;
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        DeserializationFields $deserializationFields = this.deserializationFields;
        result = result * 59 + ($deserializationFields == null ? 43 : ((Object)$deserializationFields).hashCode());
        return result;
    }

    private CustomDeserializer(InvocableDeserializer<?> invocableDeserializer, List<CustomDeserializationField> fields, DeserializationFields deserializationFields) {
        this.invocableDeserializer = invocableDeserializer;
        this.fields = fields;
        this.deserializationFields = deserializationFields;
    }
}

