/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.detection.serializedobject;

import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;

public final class CodeNeedsToBeCompiledWithParameterNamesException
extends RuntimeException {
    private CodeNeedsToBeCompiledWithParameterNamesException(String message) {
        super(message);
    }

    public static void validateParameterNamesArePresent(Class<?> type) {
        Arrays.stream(type.getDeclaredMethods()).filter(method -> Modifier.isPublic(method.getModifiers())).forEach(CodeNeedsToBeCompiledWithParameterNamesException::validateParameterNamesArePresent);
    }

    private static void validateParameterNamesArePresent(Executable method) {
        NotNullValidator.validateNotNull(method, "method");
        if (method.getParameterCount() == 0) {
            return;
        }
        Parameter[] parameters = method.getParameters();
        boolean allNamesArePresent = Arrays.stream(parameters).allMatch(Parameter::isNamePresent);
        if (!allNamesArePresent) {
            throw CodeNeedsToBeCompiledWithParameterNamesException.codeNeedsToBeCompiledWithParameterNamesException(method);
        }
    }

    private static CodeNeedsToBeCompiledWithParameterNamesException codeNeedsToBeCompiledWithParameterNamesException(Executable method) {
        String className = method.getDeclaringClass().getName();
        String methodName = method.getName();
        String message = String.format("The class '%s' has been compiled without the '-parameters' compiler option, therefore its method '%s' cannot be used%nwith MapMaid. MapMaid relies heavily on parameter names of the factory methods it needs to call.%nThis is the only way to map values in formats like Json, XML or YAML to specific parameters in factory methods.%n In order to fix this, make sure that the '-parameters' compile option is set in your build system and IDE.", className, methodName);
        return new CodeNeedsToBeCompiledWithParameterNamesException(message);
    }
}

