/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.detection.serializedobject;

import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.reflectmaid.ArrayType;
import de.quantummaid.reflectmaid.ClassType;
import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.TypeVariableName;
import java.util.Collection;
import java.util.Optional;

public final class Mirror {
    private Mirror() {
    }

    public static boolean mirrors(TypeIdentifier typeIdentifierA, TypeIdentifier typeIdentifierB) {
        if (typeIdentifierA.isVirtual() && typeIdentifierB.isVirtual()) {
            return typeIdentifierA.equals(typeIdentifierB);
        }
        if (typeIdentifierA.isVirtual()) {
            return false;
        }
        if (typeIdentifierB.isVirtual()) {
            return false;
        }
        ResolvedType typeA = typeIdentifierA.getRealType();
        ResolvedType typeB = typeIdentifierB.getRealType();
        Optional<ResolvedType> componentA = Mirror.collectionComponent(typeA);
        Optional<ResolvedType> componentB = Mirror.collectionComponent(typeB);
        if (componentA.isPresent() && componentB.isPresent()) {
            return componentA.get().equals(componentB.get());
        }
        return typeA.equals(typeB);
    }

    private static Optional<ResolvedType> collectionComponent(ResolvedType type) {
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return Optional.of(arrayType.componentType());
        }
        Class assignableType = type.assignableType();
        if (Collection.class.isAssignableFrom(assignableType)) {
            ClassType classType = (ClassType)type;
            return Optional.of(classType.typeParameter(TypeVariableName.typeVariableName((String)"E")));
        }
        return Optional.empty();
    }
}

