/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving;

import de.quantummaid.mapmaid.builder.resolving.processing.CollectionResult;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.Objects;

public final class Report {
    private final CollectionResult result;
    private final String errorMessage;

    public static Report success(CollectionResult result) {
        NotNullValidator.validateNotNull(result, "result");
        return new Report(result, null);
    }

    public static Report failure(CollectionResult result, String errorMessage) {
        NotNullValidator.validateNotNull(errorMessage, "errorMessage");
        return new Report(result, errorMessage);
    }

    public boolean isSuccess() {
        return Objects.isNull(this.errorMessage);
    }

    public CollectionResult result() {
        NotNullValidator.validateNotNull(this.result, "result");
        return this.result;
    }

    public String errorMessage() {
        NotNullValidator.validateNotNull(this.errorMessage, "errorMessage");
        return this.errorMessage;
    }

    public String toString() {
        return "Report(result=" + this.result + ", errorMessage=" + this.errorMessage + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Report)) {
            return false;
        }
        Report other = (Report)o;
        CollectionResult this$result = this.result;
        CollectionResult other$result = other.result;
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        String this$errorMessage = this.errorMessage;
        String other$errorMessage = other.errorMessage;
        return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CollectionResult $result = this.result;
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        String $errorMessage = this.errorMessage;
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }

    private Report(CollectionResult result, String errorMessage) {
        this.result = result;
        this.errorMessage = errorMessage;
    }
}

