/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.disambiguator;

import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.List;
import java.util.Objects;

public final class SerializersAndDeserializers {
    private final List<TypeSerializer> serializers;
    private final List<TypeDeserializer> deserializers;

    public static SerializersAndDeserializers serializersOnly(List<TypeSerializer> serializers) {
        NotNullValidator.validateNotNull(serializers, "serializers");
        return new SerializersAndDeserializers(serializers, null);
    }

    public static SerializersAndDeserializers deserializersOnly(List<TypeDeserializer> deserializers) {
        NotNullValidator.validateNotNull(deserializers, "deserializers");
        return new SerializersAndDeserializers(null, deserializers);
    }

    public static SerializersAndDeserializers serializersAndDeserializers(List<TypeSerializer> serializers, List<TypeDeserializer> deserializers) {
        return new SerializersAndDeserializers(serializers, deserializers);
    }

    public boolean deserializationOnly() {
        return Objects.isNull(this.serializers);
    }

    public boolean serializationOnly() {
        return Objects.isNull(this.deserializers);
    }

    public List<TypeSerializer> serializers() {
        return this.serializers;
    }

    public List<TypeDeserializer> deserializers() {
        return this.deserializers;
    }

    public String toString() {
        return "SerializersAndDeserializers(serializers=" + this.serializers + ", deserializers=" + this.deserializers + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerializersAndDeserializers)) {
            return false;
        }
        SerializersAndDeserializers other = (SerializersAndDeserializers)o;
        List<TypeSerializer> this$serializers = this.serializers;
        List<TypeSerializer> other$serializers = other.serializers;
        if (this$serializers == null ? other$serializers != null : !((Object)this$serializers).equals(other$serializers)) {
            return false;
        }
        List<TypeDeserializer> this$deserializers = this.deserializers;
        List<TypeDeserializer> other$deserializers = other.deserializers;
        return !(this$deserializers == null ? other$deserializers != null : !((Object)this$deserializers).equals(other$deserializers));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<TypeSerializer> $serializers = this.serializers;
        result = result * 59 + ($serializers == null ? 43 : ((Object)$serializers).hashCode());
        List<TypeDeserializer> $deserializers = this.deserializers;
        result = result * 59 + ($deserializers == null ? 43 : ((Object)$deserializers).hashCode());
        return result;
    }

    private SerializersAndDeserializers(List<TypeSerializer> serializers, List<TypeDeserializer> deserializers) {
        this.serializers = serializers;
        this.deserializers = deserializers;
    }
}

