/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.states.undetectable;

import de.quantummaid.mapmaid.builder.resolving.Context;
import de.quantummaid.mapmaid.builder.resolving.Report;
import de.quantummaid.mapmaid.builder.resolving.processing.CollectionResult;
import de.quantummaid.mapmaid.builder.resolving.states.StatefulDefinition;
import de.quantummaid.mapmaid.builder.resolving.states.StatefulSerializer;
import de.quantummaid.mapmaid.debug.ScanInformationBuilder;

public final class UndetectableSerializer
extends StatefulSerializer {
    private final String reason;

    private UndetectableSerializer(Context context, String reason) {
        super(context);
        this.reason = reason;
    }

    public static StatefulDefinition undetectableSerializer(Context context, String reason) {
        return new UndetectableSerializer(context, reason);
    }

    @Override
    public Report getDefinition() {
        ScanInformationBuilder scanInformationBuilder = this.context.scanInformationBuilder();
        CollectionResult collectionResult = CollectionResult.collectionResult(null, scanInformationBuilder);
        return Report.failure(collectionResult, "unable to detect serializer:\n" + this.reason);
    }

    public String toString() {
        return "UndetectableSerializer(reason=" + this.reason + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UndetectableSerializer)) {
            return false;
        }
        UndetectableSerializer other = (UndetectableSerializer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$reason = this.reason;
        String other$reason = other.reason;
        return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UndetectableSerializer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $reason = this.reason;
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        return result;
    }
}

