/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects;

import de.quantummaid.mapmaid.mapper.deserialization.DeserializationFields;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.SerializedObjectDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.IncompatibleSerializedObjectException;
import de.quantummaid.mapmaid.shared.identifier.RealTypeIdentifier;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.reflectmaid.ClassType;
import de.quantummaid.reflectmaid.resolver.ResolvedConstructor;
import de.quantummaid.reflectmaid.resolver.ResolvedParameter;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class ConstructorSerializedObjectDeserializer
implements SerializedObjectDeserializer {
    private final DeserializationFields fields;
    private final ResolvedConstructor factoryConstructor;
    private final List<String> parameterNames;

    public static SerializedObjectDeserializer createDeserializer(ClassType type, ResolvedConstructor deserializationConstructor) {
        ConstructorSerializedObjectDeserializer.validateDeserializerModifiers(type, deserializationConstructor);
        return ConstructorSerializedObjectDeserializer.verifiedDeserializationDTOConstructor(deserializationConstructor);
    }

    private static ConstructorSerializedObjectDeserializer verifiedDeserializationDTOConstructor(ResolvedConstructor factoryConstructor) {
        List parameters = factoryConstructor.parameters();
        List<String> parameterNames = parameters.stream().map(ResolvedParameter::parameter).map(Parameter::getName).collect(Collectors.toList());
        Map<String, TypeIdentifier> parameterFields = parameters.stream().collect(Collectors.toMap(ResolvedParameter::name, parameter -> RealTypeIdentifier.realTypeIdentifier(parameter.type())));
        return new ConstructorSerializedObjectDeserializer(DeserializationFields.deserializationFields(parameterFields), factoryConstructor, parameterNames);
    }

    @Override
    public Object deserialize(Map<String, Object> elements) throws Exception {
        Object[] arguments = new Object[this.parameterNames.size()];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = elements.get(this.parameterNames.get(i));
        }
        return this.factoryConstructor.constructor().newInstance(arguments);
    }

    @Override
    public DeserializationFields fields() {
        return this.fields;
    }

    private static void validateDeserializerModifiers(ClassType type, ResolvedConstructor deserializationConstructor) {
        int deserializationMethodModifiers = deserializationConstructor.constructor().getModifiers();
        if (Modifier.isAbstract(deserializationMethodModifiers)) {
            throw IncompatibleSerializedObjectException.incompatibleSerializedObjectException("The deserialization constructor %s configured for the SerializedObject of type %s must not be abstract", deserializationConstructor, type);
        }
        if (deserializationConstructor.constructor().getDeclaringClass() != type.assignableType()) {
            throw IncompatibleSerializedObjectException.incompatibleSerializedObjectException("The deserialization constructor %s configured for the SerializedObject of type %s must return the DTO", deserializationConstructor, type);
        }
    }

    @Override
    public String description() {
        return SerializedObjectDeserializer.createDescription(this.factoryConstructor.describe());
    }

    public ResolvedConstructor constructor() {
        return this.factoryConstructor;
    }

    public String toString() {
        return "ConstructorSerializedObjectDeserializer(fields=" + this.fields + ", factoryConstructor=" + this.factoryConstructor + ", parameterNames=" + this.parameterNames + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConstructorSerializedObjectDeserializer)) {
            return false;
        }
        ConstructorSerializedObjectDeserializer other = (ConstructorSerializedObjectDeserializer)o;
        DeserializationFields this$fields = this.fields;
        DeserializationFields other$fields = other.fields;
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        ResolvedConstructor this$factoryConstructor = this.factoryConstructor;
        ResolvedConstructor other$factoryConstructor = other.factoryConstructor;
        if (this$factoryConstructor == null ? other$factoryConstructor != null : !this$factoryConstructor.equals(other$factoryConstructor)) {
            return false;
        }
        List<String> this$parameterNames = this.parameterNames;
        List<String> other$parameterNames = other.parameterNames;
        return !(this$parameterNames == null ? other$parameterNames != null : !((Object)this$parameterNames).equals(other$parameterNames));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DeserializationFields $fields = this.fields;
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        ResolvedConstructor $factoryConstructor = this.factoryConstructor;
        result = result * 59 + ($factoryConstructor == null ? 43 : $factoryConstructor.hashCode());
        List<String> $parameterNames = this.parameterNames;
        result = result * 59 + ($parameterNames == null ? 43 : ((Object)$parameterNames).hashCode());
        return result;
    }

    private ConstructorSerializedObjectDeserializer(DeserializationFields fields, ResolvedConstructor factoryConstructor, List<String> parameterNames) {
        this.fields = fields;
        this.factoryConstructor = factoryConstructor;
        this.parameterNames = parameterNames;
    }
}

