/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.injector;

import de.quantummaid.mapmaid.Collection;
import de.quantummaid.mapmaid.mapper.injector.NamedDirectInjection;
import de.quantummaid.mapmaid.mapper.injector.PropertyName;
import de.quantummaid.mapmaid.mapper.injector.TypedDirectInjection;
import de.quantummaid.mapmaid.mapper.injector.UniversalInjection;
import de.quantummaid.mapmaid.mapper.universal.Universal;
import de.quantummaid.mapmaid.mapper.universal.UniversalPrimitive;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.reflectmaid.ClassType;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.List;
import java.util.Optional;

public final class Injector {
    private final List<UniversalInjection> universalInjections = Collection.smallList();
    private final List<NamedDirectInjection> namedDirectInjections = Collection.smallList();
    private final List<TypedDirectInjection> typedDirectInjections = Collection.smallList();

    static Injector empty() {
        return new Injector();
    }

    public Injector put(String propertyName, String value) {
        this.universalInjections.add(UniversalInjection.universalInjection(PropertyName.propertyName(propertyName), UniversalPrimitive.universalPrimitive(value)));
        return this;
    }

    public Injector put(String propertyName, Object instance) {
        this.namedDirectInjections.add(NamedDirectInjection.namedDirectInjection(PropertyName.propertyName(propertyName), instance));
        return this;
    }

    public Injector put(Object instance) {
        return this.put(ClassType.typeOfObject((Object)instance), instance);
    }

    public Injector put(Class<?> type, Object instance) {
        return this.put((ResolvedType)ClassType.fromClassWithoutGenerics(type), instance);
    }

    public Injector put(ResolvedType type, Object instance) {
        this.typedDirectInjections.add(TypedDirectInjection.typedDirectInjection(type, instance));
        return this;
    }

    public Optional<Universal> getUniversalInjectionFor(String position) {
        PropertyName propertyName = PropertyName.propertyName(position);
        return this.universalInjections.stream().filter(injection -> injection.propertyName().equals(propertyName)).findFirst().map(UniversalInjection::value);
    }

    public Optional<Object> getDirectInjectionForPropertyPath(String position) {
        PropertyName propertyName = PropertyName.propertyName(position);
        return this.namedDirectInjections.stream().filter(injection -> injection.propertyName().equals(propertyName)).findFirst().map(NamedDirectInjection::value);
    }

    public Optional<Object> getDirectInjectionForType(TypeIdentifier typeIdentifier) {
        if (typeIdentifier.isVirtual()) {
            return Optional.empty();
        }
        ResolvedType type = typeIdentifier.getRealType();
        Class clazz = type.assignableType();
        return this.typedDirectInjections.stream().filter(injection -> clazz.isAssignableFrom(injection.type().assignableType())).findFirst().map(TypedDirectInjection::value);
    }

    public String toString() {
        return "Injector(universalInjections=" + this.universalInjections + ", namedDirectInjections=" + this.namedDirectInjections + ", typedDirectInjections=" + this.typedDirectInjections + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Injector)) {
            return false;
        }
        Injector other = (Injector)o;
        List<UniversalInjection> this$universalInjections = this.universalInjections;
        List<UniversalInjection> other$universalInjections = other.universalInjections;
        if (this$universalInjections == null ? other$universalInjections != null : !((Object)this$universalInjections).equals(other$universalInjections)) {
            return false;
        }
        List<NamedDirectInjection> this$namedDirectInjections = this.namedDirectInjections;
        List<NamedDirectInjection> other$namedDirectInjections = other.namedDirectInjections;
        if (this$namedDirectInjections == null ? other$namedDirectInjections != null : !((Object)this$namedDirectInjections).equals(other$namedDirectInjections)) {
            return false;
        }
        List<TypedDirectInjection> this$typedDirectInjections = this.typedDirectInjections;
        List<TypedDirectInjection> other$typedDirectInjections = other.typedDirectInjections;
        return !(this$typedDirectInjections == null ? other$typedDirectInjections != null : !((Object)this$typedDirectInjections).equals(other$typedDirectInjections));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<UniversalInjection> $universalInjections = this.universalInjections;
        result = result * 59 + ($universalInjections == null ? 43 : ((Object)$universalInjections).hashCode());
        List<NamedDirectInjection> $namedDirectInjections = this.namedDirectInjections;
        result = result * 59 + ($namedDirectInjections == null ? 43 : ((Object)$namedDirectInjections).hashCode());
        List<TypedDirectInjection> $typedDirectInjections = this.typedDirectInjections;
        result = result * 59 + ($typedDirectInjections == null ? 43 : ((Object)$typedDirectInjections).hashCode());
        return result;
    }

    private Injector() {
    }
}

