/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.marshalling;

import de.quantummaid.mapmaid.shared.validators.RequiredStringValidator;

public final class MarshallingType {
    public static final MarshallingType JSON = MarshallingType.json();
    public static final MarshallingType XML = MarshallingType.xml();
    public static final MarshallingType YAML = MarshallingType.yaml();
    private final String type;

    public static MarshallingType marshallingType(String type) {
        RequiredStringValidator.validateNotNullNorEmpty(type, "type");
        return new MarshallingType(type);
    }

    public static MarshallingType json() {
        return MarshallingType.marshallingType("json");
    }

    public static MarshallingType xml() {
        return MarshallingType.marshallingType("xml");
    }

    public static MarshallingType yaml() {
        return MarshallingType.marshallingType("yaml");
    }

    public String internalValueForMapping() {
        return this.type;
    }

    public String toString() {
        return "MarshallingType(type=" + this.type + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MarshallingType)) {
            return false;
        }
        MarshallingType other = (MarshallingType)o;
        String this$type = this.type;
        String other$type = other.type;
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    private MarshallingType(String type) {
        this.type = type;
    }
}

