/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.serialization.serializers.customprimitives;

import de.quantummaid.mapmaid.mapper.serialization.serializers.customprimitives.CustomPrimitiveSerializationMethodCallException;
import de.quantummaid.mapmaid.mapper.serialization.serializers.customprimitives.CustomPrimitiveSerializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.customprimitives.IncompatibleCustomPrimitiveException;
import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.resolver.ResolvedMethod;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

public final class MethodCustomPrimitiveSerializer
implements CustomPrimitiveSerializer {
    private final ResolvedType baseType;
    private final ResolvedMethod serializationMethod;

    public static CustomPrimitiveSerializer createSerializer(ResolvedType type, ResolvedMethod serializationMethod) {
        int serializationMethodModifiers = serializationMethod.method().getModifiers();
        if (Modifier.isStatic(serializationMethodModifiers)) {
            throw IncompatibleCustomPrimitiveException.incompatibleCustomPrimitiveException("The serialization method %s configured for the custom primitive of type %s must not be static", serializationMethod, type.description());
        }
        if (serializationMethod.parameters().size() > 0) {
            throw IncompatibleCustomPrimitiveException.incompatibleCustomPrimitiveException("The serialization method %s configured for the custom primitive of type %s must not accept any parameters", serializationMethod, type.description());
        }
        ResolvedType baseType = (ResolvedType)serializationMethod.returnType().get();
        return new MethodCustomPrimitiveSerializer(baseType, serializationMethod);
    }

    @Override
    public Object serialize(Object object) {
        try {
            return this.serializationMethod.method().invoke(object, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw CustomPrimitiveSerializationMethodCallException.customPrimitiveSerializationMethodCallException(String.format("This should never happen. Called serialization method %s for custom type %s on instance %s", this.serializationMethod, object.getClass(), object), e);
        }
        catch (InvocationTargetException e) {
            throw CustomPrimitiveSerializationMethodCallException.customPrimitiveSerializationMethodCallException(String.format("Got exception calling serialization method %s for custom type %s on instance %s", this.serializationMethod, object.getClass(), object), e);
        }
    }

    @Override
    public Class<?> baseType() {
        return this.baseType.assignableType();
    }

    public ResolvedMethod method() {
        return this.serializationMethod;
    }

    @Override
    public String description() {
        return String.format("as custom primitive using %s", this.serializationMethod.describe());
    }

    public String toString() {
        return "MethodCustomPrimitiveSerializer(baseType=" + this.baseType + ", serializationMethod=" + this.serializationMethod + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodCustomPrimitiveSerializer)) {
            return false;
        }
        MethodCustomPrimitiveSerializer other = (MethodCustomPrimitiveSerializer)o;
        ResolvedType this$baseType = this.baseType;
        ResolvedType other$baseType = other.baseType;
        if (this$baseType == null ? other$baseType != null : !this$baseType.equals(other$baseType)) {
            return false;
        }
        ResolvedMethod this$serializationMethod = this.serializationMethod;
        ResolvedMethod other$serializationMethod = other.serializationMethod;
        return !(this$serializationMethod == null ? other$serializationMethod != null : !this$serializationMethod.equals(other$serializationMethod));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResolvedType $baseType = this.baseType;
        result = result * 59 + ($baseType == null ? 43 : $baseType.hashCode());
        ResolvedMethod $serializationMethod = this.serializationMethod;
        result = result * 59 + ($serializationMethod == null ? 43 : $serializationMethod.hashCode());
        return result;
    }

    private MethodCustomPrimitiveSerializer(ResolvedType baseType, ResolvedMethod serializationMethod) {
        this.baseType = baseType;
        this.serializationMethod = serializationMethod;
    }
}

