/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import de.quantummaid.mapmaid.builder.DependencyRegistry;
import de.quantummaid.mapmaid.builder.MapMaidBuilder;
import de.quantummaid.mapmaid.builder.recipes.Recipe;
import de.quantummaid.mapmaid.jackson.AlwaysStringValueJacksonDeserializerModifier;
import de.quantummaid.mapmaid.mapper.marshalling.MarshallingType;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;

public final class JacksonMarshaller
implements Recipe {
    private final MarshallingType marshallingType;
    private final ObjectMapper objectMapper;

    public static JacksonMarshaller jacksonMarshallerFor(MarshallingType marshallingType, ObjectMapper objectMapper) {
        NotNullValidator.validateNotNull((Object)objectMapper, (String)"objectMapper");
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.setDeserializerModifier((BeanDeserializerModifier)new AlwaysStringValueJacksonDeserializerModifier());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.registerModule((Module)simpleModule);
        return new JacksonMarshaller(marshallingType, objectMapper);
    }

    public static JacksonMarshaller jacksonMarshallerJson() {
        return JacksonMarshaller.jacksonMarshallerFor(MarshallingType.json(), new ObjectMapper());
    }

    public static JacksonMarshaller jacksonMarshallerXml() {
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.enable(SerializationFeature.INDENT_OUTPUT);
        return JacksonMarshaller.jacksonMarshallerFor(MarshallingType.xml(), (ObjectMapper)xmlMapper);
    }

    public static JacksonMarshaller jacksonMarshallerYaml() {
        YAMLMapper yamlMapper = new YAMLMapper();
        return JacksonMarshaller.jacksonMarshallerFor(MarshallingType.yaml(), (ObjectMapper)yamlMapper);
    }

    public void cook(MapMaidBuilder mapMaidBuilder, DependencyRegistry dependencyRegistry) {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.setDeserializerModifier((BeanDeserializerModifier)new AlwaysStringValueJacksonDeserializerModifier());
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.registerModule((Module)simpleModule);
        mapMaidBuilder.usingMarshaller(this.marshallingType, arg_0 -> ((ObjectMapper)this.objectMapper).writeValueAsString(arg_0), (arg_0, arg_1) -> ((ObjectMapper)this.objectMapper).readValue(arg_0, arg_1));
    }

    public String toString() {
        return "JacksonMarshaller(marshallingType=" + this.marshallingType + ", objectMapper=" + this.objectMapper + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JacksonMarshaller)) {
            return false;
        }
        JacksonMarshaller other = (JacksonMarshaller)o;
        MarshallingType this$marshallingType = this.marshallingType;
        MarshallingType other$marshallingType = other.marshallingType;
        if (this$marshallingType == null ? other$marshallingType != null : !this$marshallingType.equals(other$marshallingType)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.objectMapper;
        ObjectMapper other$objectMapper = other.objectMapper;
        return !(this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MarshallingType $marshallingType = this.marshallingType;
        result = result * 59 + ($marshallingType == null ? 43 : $marshallingType.hashCode());
        ObjectMapper $objectMapper = this.objectMapper;
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        return result;
    }

    private JacksonMarshaller(MarshallingType marshallingType, ObjectMapper objectMapper) {
        this.marshallingType = marshallingType;
        this.objectMapper = objectMapper;
    }
}

