/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.quantummaid.mapmaid.mapper.marshalling.Unmarshaller;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;

public final class JacksonUnmarshaller
implements Unmarshaller {
    private final ObjectMapper objectMapper;

    public static JacksonUnmarshaller jacksonUnmarshaller(ObjectMapper objectMapper) {
        NotNullValidator.validateNotNull((Object)objectMapper, (String)"objectMapper");
        return new JacksonUnmarshaller(objectMapper);
    }

    public Object unmarshal(String input) throws Exception {
        return this.objectMapper.readValue(input, Object.class);
    }

    public String toString() {
        return "JacksonUnmarshaller(objectMapper=" + this.objectMapper + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JacksonUnmarshaller)) {
            return false;
        }
        JacksonUnmarshaller other = (JacksonUnmarshaller)o;
        ObjectMapper this$objectMapper = this.objectMapper;
        ObjectMapper other$objectMapper = other.objectMapper;
        return !(this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectMapper $objectMapper = this.objectMapper;
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        return result;
    }

    private JacksonUnmarshaller(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

