/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import de.quantummaid.mapmaid.jackson.AlwaysStringValueJacksonDeserializerModifier;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;

final class ObjectMappers {
    private ObjectMappers() {
    }

    static ObjectMapper objectMapperJson() {
        return ObjectMappers.objectMapperFor(new ObjectMapper());
    }

    public static ObjectMapper objectMapperXml() {
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.enable(SerializationFeature.INDENT_OUTPUT);
        return ObjectMappers.objectMapperFor((ObjectMapper)xmlMapper);
    }

    public static ObjectMapper objectMapperYaml() {
        YAMLMapper yamlMapper = new YAMLMapper();
        return ObjectMappers.objectMapperFor((ObjectMapper)yamlMapper);
    }

    private static ObjectMapper objectMapperFor(ObjectMapper objectMapper) {
        NotNullValidator.validateNotNull((Object)objectMapper, (String)"objectMapper");
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.setDeserializerModifier((BeanDeserializerModifier)new AlwaysStringValueJacksonDeserializerModifier());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.registerModule((Module)simpleModule);
        return objectMapper;
    }
}

