/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import java.io.IOException;
import java.util.Set;

final class AlwaysStringValueJacksonDeserializer
extends UntypedObjectDeserializer {
    private static final Set<Integer> STRING_TOKENS = Set.of(Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9), Integer.valueOf(10));

    AlwaysStringValueJacksonDeserializer() {
        super(null, null);
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        int currentTokenId = p.getCurrentTokenId();
        if (STRING_TOKENS.contains(currentTokenId)) {
            if (this._stringDeserializer != null) {
                return this._stringDeserializer.deserialize(p, ctxt);
            }
            return p.getText();
        }
        return super.deserialize(p, ctxt);
    }
}

