/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.testsupport.domain.scannable;

import de.quantummaid.mapmaid.testsupport.domain.exceptions.AnException;
import java.io.Serializable;
import java.util.Objects;

public final class AScannableNumber
implements Serializable {
    public static final int MAX_VALUE = 50;
    private final int value;

    private AScannableNumber(int value) {
        this.value = value;
    }

    public static AScannableNumber fromInt(int value) {
        return new AScannableNumber(value);
    }

    public static AScannableNumber fromString(String value) {
        Integer integer = Integer.valueOf(value);
        if (integer > 50) {
            throw AnException.anException("value cannot be over 50");
        }
        return new AScannableNumber(integer);
    }

    public String internalValueForMapping() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AScannableNumber aNumber = (AScannableNumber)o;
        return this.value == aNumber.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "AScannableNumber{value=" + this.value + "}";
    }

    public boolean isLowerThen(int value) {
        return this.value < value;
    }
}

