/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.testsupport.givenwhenthen;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.gson.Gson;
import de.quantummaid.mapmaid.mapper.marshalling.Unmarshaller;
import java.io.IOException;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public final class Unmarshallers {
    private Unmarshallers() {
    }

    public static Unmarshaller jsonUnmarshaller() {
        Gson gson = new Gson();
        return input -> gson.fromJson(input, Object.class);
    }

    public static Unmarshaller xmlUnmarshaller() {
        XmlMapper xmlMapper = new XmlMapper();
        return input -> {
            try {
                return xmlMapper.readValue(input, Object.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static Unmarshaller yamlUnmarshaller() {
        DumperOptions options = new DumperOptions();
        Yaml yaml = new Yaml(options);
        return arg_0 -> ((Yaml)yaml).load(arg_0);
    }
}

