/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.testsupport.givenwhenthen;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.quantummaid.mapmaid.mapper.marshalling.Marshaller;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public final class Marshallers {
    private Marshallers() {
    }

    public static Marshaller jsonMarshaller() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return arg_0 -> ((Gson)gson).toJson(arg_0);
    }

    public static Marshaller xmlMarshaller() {
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.enable(SerializationFeature.INDENT_OUTPUT);
        return object -> {
            try {
                return xmlMapper.writeValueAsString(object);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static Marshaller yamlMarshaller() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        Yaml yaml = new Yaml(options);
        return arg_0 -> ((Yaml)yaml).dump(arg_0);
    }
}

