/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.reflectmaid;

import de.quantummaid.reflectmaid.ArrayType;
import de.quantummaid.reflectmaid.ClassType;
import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.TypeVariableName;
import de.quantummaid.reflectmaid.UnsupportedJvmFeatureInTypeException;
import de.quantummaid.reflectmaid.WildcardedType;
import de.quantummaid.reflectmaid.validators.NotNullValidator;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.List;

public final class TypeResolver {
    private TypeResolver() {
    }

    public static ResolvedType resolveType(Type type, ClassType context) {
        if (type instanceof Class) {
            return TypeResolver.resolveClass((Class)type, context);
        }
        if (type instanceof TypeVariable) {
            return TypeResolver.resolveTypeVariable((TypeVariable)type, context);
        }
        if (type instanceof ParameterizedType) {
            return TypeResolver.resolveParameterizedType((ParameterizedType)type, context);
        }
        if (type instanceof GenericArrayType) {
            return TypeResolver.resolveGenericArrayType((GenericArrayType)type, context);
        }
        if (type instanceof WildcardType) {
            return WildcardedType.wildcardType();
        }
        throw UnsupportedJvmFeatureInTypeException.unsupportedJvmFeatureInTypeException(String.format("Unknown 'Type' implementation by class '%s' on object '%s'", type.getClass(), type));
    }

    private static ResolvedType resolveClass(Class<?> clazz, ClassType fullType) {
        NotNullValidator.validateNotNull(clazz, "clazz");
        if (clazz.isArray()) {
            ResolvedType componentType = TypeResolver.resolveType(clazz.getComponentType(), fullType);
            return ArrayType.arrayType(componentType);
        }
        return ClassType.fromClassWithoutGenerics(clazz);
    }

    private static ResolvedType resolveTypeVariable(TypeVariable<?> typeVariable, ClassType fullType) {
        TypeVariableName typeVariableName = TypeVariableName.typeVariableName(typeVariable);
        return fullType.resolveTypeVariable(typeVariableName);
    }

    private static ResolvedType resolveParameterizedType(ParameterizedType parameterizedType, ClassType context) {
        Class rawType = (Class)parameterizedType.getRawType();
        List<TypeVariableName> typeVariableNames = TypeVariableName.typeVariableNamesOf(rawType);
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        HashMap<TypeVariableName, ResolvedType> typeParameters = new HashMap<TypeVariableName, ResolvedType>(actualTypeArguments.length);
        for (int i = 0; i < actualTypeArguments.length; ++i) {
            ResolvedType resolvedTypeArgument = TypeResolver.resolveType(actualTypeArguments[i], context);
            TypeVariableName name = typeVariableNames.get(i);
            typeParameters.put(name, resolvedTypeArgument);
        }
        return ClassType.fromClassWithGenerics(rawType, typeParameters);
    }

    private static ArrayType resolveGenericArrayType(GenericArrayType genericArrayType, ClassType context) {
        Type componentType = genericArrayType.getGenericComponentType();
        ResolvedType fullComponentType = TypeResolver.resolveType(componentType, context);
        return ArrayType.arrayType(fullComponentType);
    }
}

