/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.reflectmaid.unresolved;

import de.quantummaid.reflectmaid.ClassType;
import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.TypeVariableName;
import de.quantummaid.reflectmaid.unresolved.breaking.TypeVariableResolvers;
import de.quantummaid.reflectmaid.validators.NotNullValidator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public final class UnresolvedType {
    private final Class<?> type;
    private final List<TypeVariableName> variables;
    private final TypeVariableResolvers resolvers;

    public static UnresolvedType unresolvedType(Class<?> type) {
        NotNullValidator.validateNotNull(type, "type");
        TypeVariableResolvers resolvers = TypeVariableResolvers.resolversFor(type);
        return new UnresolvedType(type, TypeVariableName.typeVariableNamesOf(type), resolvers);
    }

    public ResolvedType resolve(ResolvedType ... values) {
        return this.resolve(Arrays.asList(values));
    }

    public ResolvedType resolve(List<ResolvedType> values) {
        if (values.size() != this.variables.size()) {
            throw new IllegalArgumentException();
        }
        HashMap<TypeVariableName, ResolvedType> resolvedParameters = new HashMap<TypeVariableName, ResolvedType>(values.size());
        for (int i = 0; i < this.variables.size(); ++i) {
            TypeVariableName name = this.variables.get(i);
            ResolvedType value = values.get(i);
            resolvedParameters.put(name, value);
        }
        if (resolvedParameters.isEmpty()) {
            return ResolvedType.resolvedType(this.type);
        }
        return ClassType.fromClassWithGenerics(this.type, resolvedParameters);
    }

    public ResolvedType resolveFromObject(Object object) {
        List<ResolvedType> typeList = this.resolvers.resolve(object);
        return this.resolve((ResolvedType[])typeList.toArray(ResolvedType[]::new));
    }

    public String toString() {
        return "UnresolvedType(type=" + this.type + ", variables=" + this.variables + ", resolvers=" + this.resolvers + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnresolvedType)) {
            return false;
        }
        UnresolvedType other = (UnresolvedType)o;
        Class<?> this$type = this.type;
        Class<?> other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<TypeVariableName> this$variables = this.variables;
        List<TypeVariableName> other$variables = other.variables;
        if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
            return false;
        }
        TypeVariableResolvers this$resolvers = this.resolvers;
        TypeVariableResolvers other$resolvers = other.resolvers;
        return !(this$resolvers == null ? other$resolvers != null : !((Object)this$resolvers).equals(other$resolvers));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<TypeVariableName> $variables = this.variables;
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        TypeVariableResolvers $resolvers = this.resolvers;
        result = result * 59 + ($resolvers == null ? 43 : ((Object)$resolvers).hashCode());
        return result;
    }

    private UnresolvedType(Class<?> type, List<TypeVariableName> variables, TypeVariableResolvers resolvers) {
        this.type = type;
        this.variables = variables;
        this.resolvers = resolvers;
    }
}

