/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.reflectmaid;

import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.TypeVariableName;
import de.quantummaid.reflectmaid.UnresolvableTypeVariableException;
import de.quantummaid.reflectmaid.resolver.ResolvedConstructor;
import de.quantummaid.reflectmaid.resolver.ResolvedField;
import de.quantummaid.reflectmaid.resolver.ResolvedMethod;
import de.quantummaid.reflectmaid.unresolved.UnresolvedType;
import de.quantummaid.reflectmaid.validators.NotNullValidator;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public final class ClassType
implements ResolvedType {
    private final Class<?> clazz;
    private final Map<TypeVariableName, ResolvedType> typeParameters;
    private List<ResolvedMethod> methods;
    private List<ResolvedConstructor> constructors;
    private List<ResolvedField> fields;

    public static ResolvedType typeOfObject(Object object) {
        NotNullValidator.validateNotNull(object, "object");
        return UnresolvedType.unresolvedType(object.getClass()).resolveFromObject(object);
    }

    public static ClassType fromClassWithoutGenerics(Class<?> type) {
        NotNullValidator.validateNotNull(type, "type");
        if (type.isArray()) {
            throw new UnsupportedOperationException();
        }
        if (type.getTypeParameters().length != 0) {
            throw new UnsupportedOperationException(String.format("Type variables of '%s' cannot be resolved", type.getName()));
        }
        return ClassType.fromClassWithGenerics(type, Collections.emptyMap());
    }

    public static ClassType fromClassWithGenerics(Class<?> type, Map<TypeVariableName, ResolvedType> typeParameters) {
        NotNullValidator.validateNotNull(type, "type");
        NotNullValidator.validateNotNull(typeParameters, "typeParameters");
        if (type.isArray()) {
            throw new UnsupportedOperationException();
        }
        return new ClassType(type, typeParameters);
    }

    public ResolvedType typeParameter(TypeVariableName name) {
        if (!this.typeParameters.containsKey(name)) {
            throw new IllegalArgumentException("No type parameter with the name: " + name.name());
        }
        return this.typeParameters.get(name);
    }

    @Override
    public List<ResolvedType> typeParameters() {
        return TypeVariableName.typeVariableNamesOf(this.clazz).stream().map(this.typeParameters::get).collect(Collectors.toList());
    }

    ResolvedType resolveTypeVariable(TypeVariableName name) {
        if (!this.typeParameters.containsKey(name)) {
            throw UnresolvableTypeVariableException.unresolvableTypeVariableException(name);
        }
        return this.typeParameters.get(name);
    }

    public List<ResolvedMethod> methods() {
        if (this.methods == null) {
            this.methods = ResolvedMethod.resolveMethodsWithResolvableTypeVariables(this);
        }
        return Collections.unmodifiableList(this.methods);
    }

    public List<ResolvedConstructor> constructors() {
        if (this.constructors == null) {
            this.constructors = ResolvedConstructor.resolveConstructors(this);
        }
        return Collections.unmodifiableList(this.constructors);
    }

    public List<ResolvedField> fields() {
        if (this.fields == null) {
            this.fields = ResolvedField.resolvedFields(this);
        }
        return Collections.unmodifiableList(this.fields);
    }

    @Override
    public String description() {
        if (this.typeParameters.isEmpty()) {
            return this.clazz.getName();
        }
        String parametersString = this.typeParameters().stream().map(ResolvedType::description).collect(Collectors.joining(", ", "<", ">"));
        return this.clazz.getName() + parametersString;
    }

    @Override
    public String simpleDescription() {
        if (this.typeParameters.isEmpty()) {
            return this.clazz.getSimpleName();
        }
        String parametersString = this.typeParameters().stream().map(ResolvedType::simpleDescription).collect(Collectors.joining(", ", "<", ">"));
        return this.clazz.getSimpleName() + parametersString;
    }

    @Override
    public boolean isPublic() {
        int modifiers = this.clazz.getModifiers();
        return Modifier.isPublic(modifiers);
    }

    @Override
    public boolean isAbstract() {
        if (this.clazz.isPrimitive()) {
            return false;
        }
        return Modifier.isAbstract(this.clazz.getModifiers());
    }

    @Override
    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    @Override
    public boolean isAnonymousClass() {
        return this.clazz.isAnonymousClass();
    }

    @Override
    public boolean isInnerClass() {
        return this.clazz.getEnclosingClass() != null;
    }

    @Override
    public boolean isLocalClass() {
        return this.clazz.isLocalClass();
    }

    @Override
    public boolean isStatic() {
        int modifiers = this.clazz.getModifiers();
        return Modifier.isStatic(modifiers);
    }

    @Override
    public boolean isAnnotation() {
        return this.clazz.isAnnotation();
    }

    @Override
    public boolean isWildcard() {
        return false;
    }

    @Override
    public Class<?> assignableType() {
        return this.clazz;
    }

    @Generated
    public String toString() {
        return "ClassType(clazz=" + this.clazz + ", typeParameters=" + this.typeParameters + ", methods=" + this.methods + ", constructors=" + this.constructors + ", fields=" + this.fields + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassType)) {
            return false;
        }
        ClassType other = (ClassType)o;
        Class<?> this$clazz = this.clazz;
        Class<?> other$clazz = other.clazz;
        if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
            return false;
        }
        Map<TypeVariableName, ResolvedType> this$typeParameters = this.typeParameters;
        Map<TypeVariableName, ResolvedType> other$typeParameters = other.typeParameters;
        return !(this$typeParameters == null ? other$typeParameters != null : !((Object)this$typeParameters).equals(other$typeParameters));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $clazz = this.clazz;
        result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
        Map<TypeVariableName, ResolvedType> $typeParameters = this.typeParameters;
        result = result * 59 + ($typeParameters == null ? 43 : ((Object)$typeParameters).hashCode());
        return result;
    }

    @Generated
    private ClassType(Class<?> clazz, Map<TypeVariableName, ResolvedType> typeParameters) {
        this.clazz = clazz;
        this.typeParameters = typeParameters;
    }
}

