/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.reflectmaid.resolver;

import de.quantummaid.reflectmaid.ClassType;
import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.TypeResolver;
import de.quantummaid.reflectmaid.validators.NotNullValidator;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import lombok.Generated;

public final class ResolvedField {
    private final String name;
    private final ResolvedType type;
    private final Field field;

    public static List<ResolvedField> resolvedFields(ClassType fullType) {
        Class<?> type = fullType.assignableType();
        return Arrays.stream(type.getDeclaredFields()).filter(field -> !field.isSynthetic()).map(field -> {
            ResolvedType resolved = TypeResolver.resolveType(field.getGenericType(), fullType);
            return ResolvedField.resolvedField(field.getName(), resolved, field);
        }).collect(Collectors.toList());
    }

    private static ResolvedField resolvedField(String name, ResolvedType type, Field field) {
        NotNullValidator.validateNotNull(name, "name");
        NotNullValidator.validateNotNull(type, "type");
        NotNullValidator.validateNotNull(field, "field");
        return new ResolvedField(name, type, field);
    }

    public String name() {
        return this.name;
    }

    public ResolvedType type() {
        return this.type;
    }

    public Field field() {
        return this.field;
    }

    public boolean isPublic() {
        int modifiers = this.field.getModifiers();
        return Modifier.isPublic(modifiers);
    }

    public boolean isStatic() {
        int modifiers = this.field.getModifiers();
        return Modifier.isStatic(modifiers);
    }

    public boolean isTransient() {
        int modifiers = this.field.getModifiers();
        return Modifier.isTransient(modifiers);
    }

    public String describe() {
        StringJoiner joiner = new StringJoiner(" ");
        int modifiers = this.field.getModifiers();
        if (this.isPublic()) {
            joiner.add("public");
        }
        if (Modifier.isProtected(modifiers)) {
            joiner.add("protected");
        }
        if (Modifier.isPrivate(modifiers)) {
            joiner.add("private");
        }
        if (this.isStatic()) {
            joiner.add("static");
        }
        if (this.isTransient()) {
            joiner.add("transient");
        }
        if (Modifier.isFinal(modifiers)) {
            joiner.add("final");
        }
        String type = this.type.simpleDescription();
        joiner.add(type);
        joiner.add(this.name);
        return joiner.toString();
    }

    @Generated
    public String toString() {
        return "ResolvedField(name=" + this.name + ", type=" + this.type + ", field=" + this.field + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResolvedField)) {
            return false;
        }
        ResolvedField other = (ResolvedField)o;
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ResolvedType this$type = this.type;
        ResolvedType other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Field this$field = this.field;
        Field other$field = other.field;
        return !(this$field == null ? other$field != null : !((Object)this$field).equals(other$field));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ResolvedType $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Field $field = this.field;
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        return result;
    }

    @Generated
    private ResolvedField(String name, ResolvedType type, Field field) {
        this.name = name;
        this.type = type;
        this.field = field;
    }
}

