/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.reflectmaid.resolver;

import de.quantummaid.reflectmaid.ClassType;
import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.TypeResolver;
import de.quantummaid.reflectmaid.validators.NotNullValidator;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public final class ResolvedParameter {
    private final ResolvedType type;
    private final Parameter parameter;

    public static List<ResolvedParameter> resolveParameters(Executable executable, ClassType fullType) {
        return Arrays.stream(executable.getParameters()).map(parameter -> ResolvedParameter.resolveParameter(fullType, parameter)).collect(Collectors.toList());
    }

    private static ResolvedParameter resolveParameter(ClassType declaringType, Parameter parameter) {
        NotNullValidator.validateNotNull(declaringType, "declaringType");
        NotNullValidator.validateNotNull(parameter, "parameter");
        Type parameterizedType = parameter.getParameterizedType();
        ResolvedType resolvedType = TypeResolver.resolveType(parameterizedType, declaringType);
        return new ResolvedParameter(resolvedType, parameter);
    }

    public ResolvedType type() {
        return this.type;
    }

    public String name() {
        return this.parameter.getName();
    }

    public Parameter parameter() {
        return this.parameter;
    }

    @Generated
    public String toString() {
        return "ResolvedParameter(type=" + this.type + ", parameter=" + this.parameter + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResolvedParameter)) {
            return false;
        }
        ResolvedParameter other = (ResolvedParameter)o;
        ResolvedType this$type = this.type;
        ResolvedType other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Parameter this$parameter = this.parameter;
        Parameter other$parameter = other.parameter;
        return !(this$parameter == null ? other$parameter != null : !((Object)this$parameter).equals(other$parameter));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResolvedType $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Parameter $parameter = this.parameter;
        result = result * 59 + ($parameter == null ? 43 : ((Object)$parameter).hashCode());
        return result;
    }

    @Generated
    private ResolvedParameter(ResolvedType type, Parameter parameter) {
        this.type = type;
        this.parameter = parameter;
    }
}

