/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.reflectmaid.resolver;

import de.quantummaid.reflectmaid.ClassType;
import de.quantummaid.reflectmaid.resolver.ResolvedParameter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public final class ResolvedConstructor {
    private final List<ResolvedParameter> parameters;
    private final Constructor<?> constructor;

    public static List<ResolvedConstructor> resolveConstructors(ClassType fullType) {
        return Arrays.stream(fullType.assignableType().getDeclaredConstructors()).filter(constructor -> !constructor.isSynthetic()).map(constructor -> ResolvedConstructor.resolveConstructor(constructor, fullType)).collect(Collectors.toList());
    }

    public static ResolvedConstructor resolveConstructor(Constructor<?> constructor, ClassType fullType) {
        List<ResolvedParameter> parameters = ResolvedParameter.resolveParameters(constructor, fullType);
        return new ResolvedConstructor(parameters, constructor);
    }

    public List<ResolvedParameter> parameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public Constructor<?> constructor() {
        return this.constructor;
    }

    public boolean isPublic() {
        int modifiers = this.constructor.getModifiers();
        return Modifier.isPublic(modifiers);
    }

    public String describe() {
        return this.constructor.toGenericString();
    }

    @Generated
    public String toString() {
        return "ResolvedConstructor(parameters=" + this.parameters + ", constructor=" + this.constructor + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResolvedConstructor)) {
            return false;
        }
        ResolvedConstructor other = (ResolvedConstructor)o;
        List<ResolvedParameter> this$parameters = this.parameters;
        List<ResolvedParameter> other$parameters = other.parameters;
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        Constructor<?> this$constructor = this.constructor;
        Constructor<?> other$constructor = other.constructor;
        return !(this$constructor == null ? other$constructor != null : !((Object)this$constructor).equals(other$constructor));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ResolvedParameter> $parameters = this.parameters;
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        Constructor<?> $constructor = this.constructor;
        result = result * 59 + ($constructor == null ? 43 : ((Object)$constructor).hashCode());
        return result;
    }

    @Generated
    private ResolvedConstructor(List<ResolvedParameter> parameters, Constructor<?> constructor) {
        this.parameters = parameters;
        this.constructor = constructor;
    }
}

