/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.reflectmaid;

import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.resolver.ResolvedConstructor;
import de.quantummaid.reflectmaid.resolver.ResolvedMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public final class ThirdPartyAnnotation {
    private final List<String> fullyQualifiedNames;

    public static ThirdPartyAnnotation thirdPartyAnnotation(String ... fullyQualifiedNames) {
        return new ThirdPartyAnnotation(Arrays.asList(fullyQualifiedNames));
    }

    public String describe() {
        return this.fullyQualifiedNames.stream().collect(Collectors.joining(", ", "[", "]"));
    }

    public boolean isAnnotatedWith(ResolvedConstructor constructor) {
        Constructor<?> rawConstructor = constructor.constructor();
        return this.isAnnotated(rawConstructor);
    }

    public boolean isAnnotatedWith(ResolvedMethod method) {
        Method rawMethod = method.method();
        return this.isAnnotated(rawMethod);
    }

    public boolean isAnnotatedWith(ResolvedType type) {
        Class<?> rawType = type.assignableType();
        return this.isAnnotated(rawType);
    }

    private boolean isAnnotated(AnnotatedElement annotatedElement) {
        Annotation[] annotations = annotatedElement.getAnnotations();
        return Arrays.stream(annotations).map(Annotation::annotationType).map(Class::getName).anyMatch(this.fullyQualifiedNames::contains);
    }

    @Generated
    public String toString() {
        return "ThirdPartyAnnotation(fullyQualifiedNames=" + this.fullyQualifiedNames + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThirdPartyAnnotation)) {
            return false;
        }
        ThirdPartyAnnotation other = (ThirdPartyAnnotation)o;
        List<String> this$fullyQualifiedNames = this.fullyQualifiedNames;
        List<String> other$fullyQualifiedNames = other.fullyQualifiedNames;
        return !(this$fullyQualifiedNames == null ? other$fullyQualifiedNames != null : !((Object)this$fullyQualifiedNames).equals(other$fullyQualifiedNames));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $fullyQualifiedNames = this.fullyQualifiedNames;
        result = result * 59 + ($fullyQualifiedNames == null ? 43 : ((Object)$fullyQualifiedNames).hashCode());
        return result;
    }

    @Generated
    private ThirdPartyAnnotation(List<String> fullyQualifiedNames) {
        this.fullyQualifiedNames = fullyQualifiedNames;
    }
}

