/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.reflectmaid.resolver;

import de.quantummaid.reflectmaid.ClassType;
import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.TypeResolver;
import de.quantummaid.reflectmaid.UnresolvableTypeVariableException;
import de.quantummaid.reflectmaid.resolver.ResolvedParameter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public final class ResolvedMethod {
    private final ResolvedType returnType;
    private final List<ResolvedParameter> parameters;
    private final Method method;

    public static List<ResolvedMethod> resolveMethodsWithResolvableTypeVariables(ClassType fullType) {
        Class<?> type = fullType.assignableType();
        Method[] declaredMethods = type.getDeclaredMethods();
        return Arrays.stream(declaredMethods).filter(method -> !method.isSynthetic()).map(method -> {
            try {
                return Optional.of(ResolvedMethod.resolveMethod(method, fullType));
            }
            catch (UnresolvableTypeVariableException e) {
                return Optional.empty();
            }
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public static ResolvedMethod resolveMethod(Method method, ClassType context) {
        Type genericReturnType = method.getGenericReturnType();
        ResolvedType returnType = genericReturnType != Void.TYPE ? TypeResolver.resolveType(genericReturnType, context) : null;
        List<ResolvedParameter> parameters = ResolvedParameter.resolveParameters(method, context);
        return new ResolvedMethod(returnType, parameters, method);
    }

    public Optional<ResolvedType> returnType() {
        return Optional.ofNullable(this.returnType);
    }

    public boolean hasParameters(List<ResolvedType> parameters) {
        if (parameters.size() != this.parameters.size()) {
            return false;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            if (parameters.get(i).equals(this.parameters.get(i).type())) continue;
            return false;
        }
        return true;
    }

    public List<ResolvedParameter> parameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public Method method() {
        return this.method;
    }

    public String name() {
        return this.method.getName();
    }

    public boolean isPublic() {
        int modifiers = this.method.getModifiers();
        return Modifier.isPublic(modifiers);
    }

    public String describe() {
        String parametersString = this.parameters.stream().map(resolvedParameter -> {
            String type = resolvedParameter.type().simpleDescription();
            String parameterName = resolvedParameter.parameter().getName();
            return String.format("%s %s", type, parameterName);
        }).collect(Collectors.joining(", "));
        String returnTypeDescription = Optional.ofNullable(this.returnType).map(type -> type.assignableType().getSimpleName()).orElse("void");
        String name = this.method.getName();
        String fullSignature = this.method.toGenericString();
        return String.format("'%s %s(%s)' [%s]", returnTypeDescription, name, parametersString, fullSignature);
    }

    @Generated
    public String toString() {
        return "ResolvedMethod(returnType=" + this.returnType + ", parameters=" + this.parameters + ", method=" + this.method + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResolvedMethod)) {
            return false;
        }
        ResolvedMethod other = (ResolvedMethod)o;
        ResolvedType this$returnType = this.returnType;
        ResolvedType other$returnType = other.returnType;
        if (this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType)) {
            return false;
        }
        List<ResolvedParameter> this$parameters = this.parameters;
        List<ResolvedParameter> other$parameters = other.parameters;
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        Method this$method = this.method;
        Method other$method = other.method;
        return !(this$method == null ? other$method != null : !((Object)this$method).equals(other$method));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResolvedType $returnType = this.returnType;
        result = result * 59 + ($returnType == null ? 43 : $returnType.hashCode());
        List<ResolvedParameter> $parameters = this.parameters;
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        Method $method = this.method;
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        return result;
    }

    @Generated
    private ResolvedMethod(ResolvedType returnType, List<ResolvedParameter> parameters, Method method) {
        this.returnType = returnType;
        this.parameters = parameters;
        this.method = method;
    }
}

