/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.reflectmaid;

import de.quantummaid.reflectmaid.ClassType;
import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.validators.NotNullValidator;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public final class ArrayType
implements ResolvedType {
    private final ResolvedType componentType;

    public static ArrayType fromArrayClass(Class<?> clazz) {
        NotNullValidator.validateNotNull(clazz, "clazz");
        if (!clazz.isArray()) {
            throw new UnsupportedOperationException();
        }
        ClassType componentType = ClassType.fromClassWithoutGenerics(clazz.getComponentType());
        return ArrayType.arrayType(componentType);
    }

    public static ArrayType arrayType(ResolvedType componentType) {
        NotNullValidator.validateNotNull(componentType, "componentType");
        return new ArrayType(componentType);
    }

    public ResolvedType componentType() {
        return this.componentType;
    }

    @Override
    public String simpleDescription() {
        return this.componentType.simpleDescription() + "[]";
    }

    @Override
    public String description() {
        return this.componentType.description() + "[]";
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isWildcard() {
        return false;
    }

    @Override
    public List<ResolvedType> typeParameters() {
        return Collections.singletonList(this.componentType);
    }

    @Override
    public Class<?> assignableType() {
        return Array.newInstance(this.componentType.assignableType(), 0).getClass();
    }

    @Generated
    public String toString() {
        return "ArrayType(componentType=" + this.componentType + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrayType)) {
            return false;
        }
        ArrayType other = (ArrayType)o;
        ResolvedType this$componentType = this.componentType;
        ResolvedType other$componentType = other.componentType;
        return !(this$componentType == null ? other$componentType != null : !this$componentType.equals(other$componentType));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResolvedType $componentType = this.componentType;
        result = result * 59 + ($componentType == null ? 43 : $componentType.hashCode());
        return result;
    }

    @Generated
    private ArrayType(ResolvedType componentType) {
        this.componentType = componentType;
    }
}

